/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.service;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsRequest;
import org.elasticsearch.xpack.core.security.action.service.GetServiceAccountCredentialsResponse;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;

public class TransportGetServiceAccountCredentialsAction
extends HandledTransportAction<GetServiceAccountCredentialsRequest, GetServiceAccountCredentialsResponse> {
    private final ServiceAccountService serviceAccountService;

    @Inject
    public TransportGetServiceAccountCredentialsAction(TransportService transportService, ActionFilters actionFilters, ServiceAccountService serviceAccountService) {
        super("cluster:admin/xpack/security/service_account/credential/get", transportService, actionFilters, GetServiceAccountCredentialsRequest::new);
        this.serviceAccountService = serviceAccountService;
    }

    protected void doExecute(Task task, GetServiceAccountCredentialsRequest request, ActionListener<GetServiceAccountCredentialsResponse> listener) {
        this.serviceAccountService.findTokensFor(request, listener);
    }
}

