/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.APMSystemUser;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.BeatsSystemUser;
import org.elasticsearch.xpack.core.security.user.ElasticUser;
import org.elasticsearch.xpack.core.security.user.KibanaSystemUser;
import org.elasticsearch.xpack.core.security.user.KibanaUser;
import org.elasticsearch.xpack.core.security.user.LogstashSystemUser;
import org.elasticsearch.xpack.core.security.user.RemoteMonitoringUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class ReservedRealm
extends CachingUsernamePasswordRealm {
    public static final String TYPE = "reserved";
    public static final String NAME = "reserved";
    private final NativeUsersStore.ReservedUserInfo bootstrapUserInfo;
    public static final Setting<Boolean> ACCEPT_DEFAULT_PASSWORD_SETTING = Setting.boolSetting((String)SecurityField.setting((String)"authc.accept_default_password"), (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Deprecated});
    public static final Setting<SecureString> BOOTSTRAP_ELASTIC_PASSWORD = SecureSetting.secureString((String)"bootstrap.password", (Setting)KeyStoreWrapper.SEED_SETTING, (Setting.Property[])new Setting.Property[0]);
    private final NativeUsersStore nativeUsersStore;
    private final AnonymousUser anonymousUser;
    private final boolean realmEnabled;
    private final boolean anonymousEnabled;
    private final SecurityIndexManager securityIndex;
    private final DeprecationLogger deprecationLogger;

    public ReservedRealm(Environment env, Settings settings, NativeUsersStore nativeUsersStore, AnonymousUser anonymousUser, SecurityIndexManager securityIndex, ThreadPool threadPool) {
        super(new RealmConfig(new RealmConfig.RealmIdentifier("reserved", "reserved"), settings, env, threadPool.getThreadContext()), threadPool);
        this.deprecationLogger = DeprecationLogger.getLogger((String)this.logger.getName());
        this.nativeUsersStore = nativeUsersStore;
        this.realmEnabled = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
        this.anonymousUser = anonymousUser;
        this.anonymousEnabled = AnonymousUser.isAnonymousEnabled((Settings)settings);
        this.securityIndex = securityIndex;
        Hasher reservedRealmHasher = Hasher.resolve((String)((String)XPackSettings.PASSWORD_HASHING_ALGORITHM.get(settings)));
        char[] hash = ((SecureString)BOOTSTRAP_ELASTIC_PASSWORD.get(settings)).length() == 0 ? new char[]{} : reservedRealmHasher.hash((SecureString)BOOTSTRAP_ELASTIC_PASSWORD.get(settings));
        this.bootstrapUserInfo = new NativeUsersStore.ReservedUserInfo(hash, true);
    }

    @Override
    protected void doAuthenticate(UsernamePasswordToken token, ActionListener<AuthenticationResult> listener) {
        if (!this.realmEnabled) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
        } else if (!ClientReservedRealm.isReserved((String)token.principal(), (Settings)this.config.settings())) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
        } else {
            this.getUserInfo(token.principal(), (ActionListener<NativeUsersStore.ReservedUserInfo>)ActionListener.wrap(userInfo -> {
                AuthenticationResult result;
                if (userInfo != null) {
                    try {
                        if (userInfo.hasEmptyPassword()) {
                            result = AuthenticationResult.terminate((String)("failed to authenticate user [" + token.principal() + "]"), null);
                        }
                        if (userInfo.verifyPassword(token.credentials())) {
                            User user = this.getUser(token.principal(), (NativeUsersStore.ReservedUserInfo)userInfo);
                            this.logDeprecatedUser(user);
                            result = AuthenticationResult.success((User)user);
                        }
                        result = AuthenticationResult.terminate((String)("failed to authenticate user [" + token.principal() + "]"), null);
                    }
                    finally {
                        assert (userInfo.passwordHash != this.bootstrapUserInfo.passwordHash) : "bootstrap user info must be cloned";
                        Arrays.fill(userInfo.passwordHash, '\u0000');
                    }
                } else {
                    result = AuthenticationResult.terminate((String)("failed to authenticate user [" + token.principal() + "]"), null);
                }
                listener.onResponse((Object)result);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    @Override
    protected void doLookupUser(String username, ActionListener<User> listener) {
        if (!this.realmEnabled) {
            if (this.anonymousEnabled && AnonymousUser.isAnonymousUsername((String)username, (Settings)this.config.settings())) {
                listener.onResponse((Object)this.anonymousUser);
            } else {
                listener.onResponse(null);
            }
        } else if (!ClientReservedRealm.isReserved((String)username, (Settings)this.config.settings())) {
            listener.onResponse(null);
        } else if (AnonymousUser.isAnonymousUsername((String)username, (Settings)this.config.settings())) {
            listener.onResponse((Object)(this.anonymousEnabled ? this.anonymousUser : null));
        } else {
            this.getUserInfo(username, (ActionListener<NativeUsersStore.ReservedUserInfo>)ActionListener.wrap(userInfo -> {
                if (userInfo != null) {
                    listener.onResponse((Object)this.getUser(username, (NativeUsersStore.ReservedUserInfo)userInfo));
                } else {
                    listener.onFailure((Exception)((Object)Exceptions.authenticationError((String)"failed to lookup user [{}]", (Object[])new Object[]{username})));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private User getUser(String username, NativeUsersStore.ReservedUserInfo userInfo) {
        assert (username != null);
        switch (username) {
            case "elastic": {
                return new ElasticUser(userInfo.enabled);
            }
            case "kibana": {
                return new KibanaUser(userInfo.enabled);
            }
            case "kibana_system": {
                return new KibanaSystemUser(userInfo.enabled);
            }
            case "logstash_system": {
                return new LogstashSystemUser(userInfo.enabled);
            }
            case "beats_system": {
                return new BeatsSystemUser(userInfo.enabled);
            }
            case "apm_system": {
                return new APMSystemUser(userInfo.enabled);
            }
            case "remote_monitoring_user": {
                return new RemoteMonitoringUser(userInfo.enabled);
            }
        }
        if (this.anonymousEnabled && this.anonymousUser.principal().equals(username)) {
            return this.anonymousUser;
        }
        return null;
    }

    public void users(ActionListener<Collection<User>> listener) {
        if (!this.realmEnabled) {
            listener.onResponse(this.anonymousEnabled ? Collections.singletonList(this.anonymousUser) : Collections.emptyList());
        } else {
            this.nativeUsersStore.getAllReservedUserInfo((ActionListener<Map<String, NativeUsersStore.ReservedUserInfo>>)ActionListener.wrap(reservedUserInfos -> {
                ArrayList<Object> users = new ArrayList<Object>(4);
                NativeUsersStore.ReservedUserInfo userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("elastic");
                users.add(new ElasticUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("kibana");
                users.add(new KibanaUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("kibana_system");
                users.add(new KibanaSystemUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("logstash_system");
                users.add(new LogstashSystemUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("beats_system");
                users.add(new BeatsSystemUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("apm_system");
                users.add(new APMSystemUser(userInfo == null || userInfo.enabled));
                userInfo = (NativeUsersStore.ReservedUserInfo)reservedUserInfos.get("remote_monitoring_user");
                users.add(new RemoteMonitoringUser(userInfo == null || userInfo.enabled));
                if (this.anonymousEnabled) {
                    users.add(this.anonymousUser);
                }
                listener.onResponse(users);
            }, e -> {
                this.logger.error("failed to retrieve reserved users", (Throwable)e);
                listener.onResponse(this.anonymousEnabled ? Collections.singletonList(this.anonymousUser) : Collections.emptyList());
            }));
        }
    }

    private void getUserInfo(String username, ActionListener<NativeUsersStore.ReservedUserInfo> listener) {
        if (!this.userIsDefinedForCurrentSecurityMapping(username)) {
            this.logger.debug("Marking user [{}] as disabled because the security mapping is not at the required version", (Object)username);
            listener.onResponse((Object)NativeUsersStore.ReservedUserInfo.defaultDisabledUserInfo());
        } else if (!this.securityIndex.indexExists()) {
            listener.onResponse((Object)this.getDefaultUserInfo(username));
        } else {
            this.nativeUsersStore.getReservedUserInfo(username, (ActionListener<NativeUsersStore.ReservedUserInfo>)ActionListener.wrap(userInfo -> {
                if (userInfo == null) {
                    listener.onResponse((Object)this.getDefaultUserInfo(username));
                } else {
                    listener.onResponse(userInfo);
                }
            }, e -> {
                this.logger.error(() -> new ParameterizedMessage("failed to retrieve password hash for reserved user [{}]", (Object)username), (Throwable)e);
                listener.onResponse(null);
            }));
        }
    }

    private void logDeprecatedUser(User user) {
        Map metadata = user.metadata();
        if (Boolean.TRUE.equals(metadata.get("_deprecated"))) {
            this.deprecationLogger.warn(DeprecationCategory.SECURITY, "deprecated_user-" + user.principal(), "The user [" + user.principal() + "] is deprecated and will be removed in a future version of Elasticsearch. " + metadata.get("_deprecated_reason"), new Object[0]);
        }
    }

    private NativeUsersStore.ReservedUserInfo getDefaultUserInfo(String username) {
        if ("elastic".equals(username)) {
            return this.bootstrapUserInfo.deepClone();
        }
        return NativeUsersStore.ReservedUserInfo.defaultEnabledUserInfo();
    }

    private boolean userIsDefinedForCurrentSecurityMapping(String username) {
        Version requiredVersion = this.getDefinedVersion(username);
        return this.securityIndex.checkMappingVersion(arg_0 -> ((Version)requiredVersion).onOrBefore(arg_0));
    }

    private Version getDefinedVersion(String username) {
        switch (username) {
            case "beats_system": {
                return BeatsSystemUser.DEFINED_SINCE;
            }
            case "apm_system": {
                return APMSystemUser.DEFINED_SINCE;
            }
            case "remote_monitoring_user": {
                return RemoteMonitoringUser.DEFINED_SINCE;
            }
        }
        return Version.V_6_0_0;
    }

    public static void addSettings(List<Setting<?>> settingsList) {
        settingsList.add(ACCEPT_DEFAULT_PASSWORD_SETTING);
        settingsList.add(BOOTSTRAP_ELASTIC_PASSWORD);
    }
}

