/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.oauth2;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

abstract class TokenBaseRestHandler
extends SecurityBaseRestHandler {
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    TokenBaseRestHandler(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    @Override
    protected Exception checkFeatureAvailable(RestRequest request) {
        Exception failedFeature = super.checkFeatureAvailable(request);
        if (failedFeature != null) {
            return failedFeature;
        }
        if (Security.TOKEN_SERVICE_FEATURE.check(this.licenseState)) {
            return null;
        }
        this.logger.info("Security tokens are not available under the current [{}] license", (Object)this.licenseState.getOperationMode().description());
        return LicenseUtils.newComplianceException((String)"security tokens");
    }
}

