/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchRequest;

class FieldCapabilitiesFetcher {
    private final IndicesService indicesService;

    FieldCapabilitiesFetcher(IndicesService indicesService) {
        this.indicesService = indicesService;
    }

    public FieldCapabilitiesIndexResponse fetch(FieldCapabilitiesIndexRequest request) throws IOException {
        ShardId shardId = request.shardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().getId());
        try (Engine.Searcher searcher = indexShard.acquireSearcher("can_match");){
            SearchExecutionContext searchExecutionContext = indexService.newSearchExecutionContext(shardId.id(), 0, searcher, request::nowInMillis, null, request.runtimeFields());
            if (!this.canMatchShard(request, searchExecutionContext)) {
                FieldCapabilitiesIndexResponse fieldCapabilitiesIndexResponse = new FieldCapabilitiesIndexResponse(request.index(), Collections.emptyMap(), false);
                return fieldCapabilitiesIndexResponse;
            }
            HashSet<String> fieldNames = new HashSet<String>();
            for (String pattern : request.fields()) {
                fieldNames.addAll(searchExecutionContext.getMatchingFieldNames(pattern));
            }
            Predicate<String> fieldPredicate = this.indicesService.getFieldFilter().apply(shardId.getIndexName());
            HashMap<String, IndexFieldCapabilities> responseMap = new HashMap<String, IndexFieldCapabilities>();
            for (String field : fieldNames) {
                String parentField;
                MappedFieldType ft = searchExecutionContext.getFieldType(field);
                boolean isMetadataField = searchExecutionContext.isMetadataField(field);
                if (!isMetadataField && !fieldPredicate.test(ft.name())) continue;
                IndexFieldCapabilities fieldCap = new IndexFieldCapabilities(field, ft.familyTypeName(), isMetadataField, ft.isSearchable(), ft.isAggregatable(), ft.meta());
                responseMap.put(field, fieldCap);
                if (ft instanceof RuntimeField) continue;
                int dotIndex = ft.name().lastIndexOf(46);
                while (dotIndex > -1 && !responseMap.containsKey(parentField = ft.name().substring(0, dotIndex))) {
                    ObjectMapper mapper;
                    if (searchExecutionContext.getFieldType(parentField) == null && (mapper = searchExecutionContext.getObjectMapper(parentField)) != null) {
                        String type = mapper.isNested() ? "nested" : "object";
                        IndexFieldCapabilities fieldCap2 = new IndexFieldCapabilities(parentField, type, false, false, false, Collections.emptyMap());
                        responseMap.put(parentField, fieldCap2);
                    }
                    dotIndex = parentField.lastIndexOf(46);
                }
            }
            FieldCapabilitiesIndexResponse fieldCapabilitiesIndexResponse = new FieldCapabilitiesIndexResponse(request.index(), responseMap, true);
            return fieldCapabilitiesIndexResponse;
        }
    }

    private boolean canMatchShard(FieldCapabilitiesIndexRequest req, SearchExecutionContext searchExecutionContext) throws IOException {
        if (req.indexFilter() == null || req.indexFilter() instanceof MatchAllQueryBuilder) {
            return true;
        }
        assert (req.nowInMillis() != 0L);
        ShardSearchRequest searchRequest = new ShardSearchRequest(req.shardId(), null, req.nowInMillis(), AliasFilter.EMPTY);
        searchRequest.source(new SearchSourceBuilder().query(req.indexFilter()));
        return SearchService.queryStillMatchesAfterRewrite(searchRequest, searchExecutionContext);
    }
}

