/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.script.ScriptStats;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ScriptCacheStats
implements Writeable,
ToXContentFragment {
    private final Map<String, ScriptStats> context;
    private final ScriptStats general;

    public ScriptCacheStats(Map<String, ScriptStats> context) {
        this.context = Collections.unmodifiableMap(context);
        this.general = null;
    }

    public ScriptCacheStats(ScriptStats general) {
        this.general = Objects.requireNonNull(general);
        this.context = null;
    }

    public ScriptCacheStats(StreamInput in) throws IOException {
        boolean isContext = in.readBoolean();
        if (!isContext) {
            this.general = new ScriptStats(in);
            this.context = null;
            return;
        }
        this.general = null;
        int size = in.readInt();
        HashMap<String, ScriptStats> context = new HashMap<String, ScriptStats>(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readString();
            context.put(name, new ScriptStats(in));
        }
        this.context = Collections.unmodifiableMap(context);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.general != null) {
            out.writeBoolean(false);
            this.general.writeTo(out);
            return;
        }
        out.writeBoolean(true);
        out.writeInt(this.context.size());
        for (String name : this.context.keySet().stream().sorted().collect(Collectors.toList())) {
            out.writeString(name);
            this.context.get(name).writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("script_cache");
        builder.startObject("sum");
        if (this.general != null) {
            builder.field("compilations", this.general.getCompilations());
            builder.field("cache_evictions", this.general.getCacheEvictions());
            builder.field("compilation_limit_triggered", this.general.getCompilationLimitTriggered());
            builder.endObject().endObject();
            return builder;
        }
        ScriptStats sum = this.sum();
        builder.field("compilations", sum.getCompilations());
        builder.field("cache_evictions", sum.getCacheEvictions());
        builder.field("compilation_limit_triggered", sum.getCompilationLimitTriggered());
        builder.endObject();
        builder.startArray("contexts");
        for (String name : this.context.keySet().stream().sorted().collect(Collectors.toList())) {
            ScriptStats stats = this.context.get(name);
            builder.startObject();
            builder.field("context", name);
            builder.field("compilations", stats.getCompilations());
            builder.field("cache_evictions", stats.getCacheEvictions());
            builder.field("compilation_limit_triggered", stats.getCompilationLimitTriggered());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public Map<String, ScriptStats> getContextStats() {
        return this.context;
    }

    public ScriptStats getGeneralStats() {
        return this.general;
    }

    public ScriptStats sum() {
        if (this.general != null) {
            return this.general;
        }
        long compilations = 0L;
        long cacheEvictions = 0L;
        long compilationLimitTriggered = 0L;
        for (ScriptStats stat : this.context.values()) {
            compilations += stat.getCompilations();
            cacheEvictions += stat.getCacheEvictions();
            compilationLimitTriggered += stat.getCompilationLimitTriggered();
        }
        return new ScriptStats(compilations, cacheEvictions, compilationLimitTriggered);
    }

    static final class Fields {
        static final String SCRIPT_CACHE_STATS = "script_cache";
        static final String CONTEXT = "context";
        static final String SUM = "sum";
        static final String CONTEXTS = "contexts";

        Fields() {
        }
    }
}

