/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.condition;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.condition.Condition;
import org.elasticsearch.xpack.core.watcher.condition.ExecutableCondition;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.condition.WatcherConditionScript;

public final class ScriptCondition
implements ExecutableCondition {
    public static final String TYPE = "script";
    private static final Condition.Result MET = new Condition.Result(null, "script", true);
    private static final Condition.Result UNMET = new Condition.Result(null, "script", false);
    private final Script script;
    private final WatcherConditionScript.Factory scriptFactory;

    public ScriptCondition(Script script) {
        this.script = script;
        this.scriptFactory = null;
    }

    ScriptCondition(Script script, ScriptService scriptService) {
        this.script = script;
        this.scriptFactory = (WatcherConditionScript.Factory)scriptService.compile(script, WatcherConditionScript.CONTEXT);
    }

    public Script getScript() {
        return this.script;
    }

    public static ScriptCondition parse(ScriptService scriptService, String watchId, XContentParser parser) throws IOException {
        try {
            Script script = Script.parse((XContentParser)parser);
            return new ScriptCondition(script, scriptService);
        }
        catch (ElasticsearchParseException pe) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. failed to parse script", (Throwable)pe, new Object[]{TYPE, watchId});
        }
    }

    public Condition.Result execute(WatchExecutionContext ctx) {
        return this.doExecute(ctx);
    }

    public Condition.Result doExecute(WatchExecutionContext ctx) {
        WatcherConditionScript conditionScript = this.scriptFactory.newInstance(this.script.getParams(), ctx);
        return conditionScript.execute() ? MET : UNMET;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.script.toXContent(builder, params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptCondition condition = (ScriptCondition)o;
        return this.script.equals((Object)condition.script);
    }

    public int hashCode() {
        return this.script.hashCode();
    }

    public String type() {
        return TYPE;
    }
}

