/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.stack;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class StackTemplateRegistry
extends IndexTemplateRegistry {
    private static final Logger logger = LogManager.getLogger(StackTemplateRegistry.class);
    public static final int REGISTRY_VERSION = 1;
    public static final String TEMPLATE_VERSION_VARIABLE = "xpack.stack.template.version";
    public static final Setting<Boolean> STACK_TEMPLATES_ENABLED = Setting.boolSetting((String)"stack.templates.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ClusterService clusterService;
    private volatile boolean stackTemplateEnabled;
    public static final String DATA_STREAMS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "data-streams-mappings";
    public static final IndexTemplateConfig DATA_STREAMS_MAPPINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("data-streams-mappings", "/data-streams-mappings.json", 1, "xpack.stack.template.version");
    public static final String ILM_7_DAYS_POLICY_NAME = "7-days-default";
    public static final String ILM_30_DAYS_POLICY_NAME = "30-days-default";
    public static final String ILM_90_DAYS_POLICY_NAME = "90-days-default";
    public static final String ILM_180_DAYS_POLICY_NAME = "180-days-default";
    public static final String ILM_365_DAYS_POLICY_NAME = "365-days-default";
    public static final LifecyclePolicyConfig ILM_7_DAYS_POLICY = new LifecyclePolicyConfig("7-days-default", "/7-days-default.json");
    public static final LifecyclePolicyConfig ILM_30_DAYS_POLICY = new LifecyclePolicyConfig("30-days-default", "/30-days-default.json");
    public static final LifecyclePolicyConfig ILM_90_DAYS_POLICY = new LifecyclePolicyConfig("90-days-default", "/90-days-default.json");
    public static final LifecyclePolicyConfig ILM_180_DAYS_POLICY = new LifecyclePolicyConfig("180-days-default", "/180-days-default.json");
    public static final LifecyclePolicyConfig ILM_365_DAYS_POLICY = new LifecyclePolicyConfig("365-days-default", "/365-days-default.json");
    public static final String LOGS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "logs-mappings";
    public static final String LOGS_SETTINGS_COMPONENT_TEMPLATE_NAME = "logs-settings";
    public static final String LOGS_ILM_POLICY_NAME = "logs";
    public static final String LOGS_INDEX_TEMPLATE_NAME = "logs";
    public static final IndexTemplateConfig LOGS_MAPPINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("logs-mappings", "/logs-mappings.json", 1, "xpack.stack.template.version");
    public static final IndexTemplateConfig LOGS_SETTINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("logs-settings", "/logs-settings.json", 1, "xpack.stack.template.version");
    public static final LifecyclePolicyConfig LOGS_ILM_POLICY = new LifecyclePolicyConfig("logs", "/logs-policy.json");
    public static final IndexTemplateConfig LOGS_INDEX_TEMPLATE = new IndexTemplateConfig("logs", "/logs-template.json", 1, "xpack.stack.template.version");
    public static final String METRICS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "metrics-mappings";
    public static final String METRICS_SETTINGS_COMPONENT_TEMPLATE_NAME = "metrics-settings";
    public static final String METRICS_ILM_POLICY_NAME = "metrics";
    public static final String METRICS_INDEX_TEMPLATE_NAME = "metrics";
    public static final IndexTemplateConfig METRICS_MAPPINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("metrics-mappings", "/metrics-mappings.json", 1, "xpack.stack.template.version");
    public static final IndexTemplateConfig METRICS_SETTINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("metrics-settings", "/metrics-settings.json", 1, "xpack.stack.template.version");
    public static final LifecyclePolicyConfig METRICS_ILM_POLICY = new LifecyclePolicyConfig("metrics", "/metrics-policy.json");
    public static final IndexTemplateConfig METRICS_INDEX_TEMPLATE = new IndexTemplateConfig("metrics", "/metrics-template.json", 1, "xpack.stack.template.version");
    public static final String SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "synthetics-mappings";
    public static final String SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE_NAME = "synthetics-settings";
    public static final String SYNTHETICS_ILM_POLICY_NAME = "synthetics";
    public static final String SYNTHETICS_INDEX_TEMPLATE_NAME = "synthetics";
    public static final IndexTemplateConfig SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("synthetics-mappings", "/synthetics-mappings.json", 1, "xpack.stack.template.version");
    public static final IndexTemplateConfig SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE = new IndexTemplateConfig("synthetics-settings", "/synthetics-settings.json", 1, "xpack.stack.template.version");
    public static final LifecyclePolicyConfig SYNTHETICS_ILM_POLICY = new LifecyclePolicyConfig("synthetics", "/synthetics-policy.json");
    public static final IndexTemplateConfig SYNTHETICS_INDEX_TEMPLATE = new IndexTemplateConfig("synthetics", "/synthetics-template.json", 1, "xpack.stack.template.version");

    public StackTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.clusterService = clusterService;
        this.stackTemplateEnabled = (Boolean)STACK_TEMPLATES_ENABLED.get(nodeSettings);
    }

    public void initialize() {
        super.initialize();
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(STACK_TEMPLATES_ENABLED, this::updateEnabledSetting);
    }

    private void updateEnabledSetting(boolean newValue) {
        if (newValue) {
            this.stackTemplateEnabled = true;
        } else {
            logger.info("stack composable templates [{}] and component templates [{}] will not be installed or reinstalled", (Object)this.getComposableTemplateConfigs().stream().map(IndexTemplateConfig::getTemplateName).collect(Collectors.joining(",")), (Object)this.getComponentTemplateConfigs().stream().map(IndexTemplateConfig::getTemplateName).collect(Collectors.joining(",")));
            this.stackTemplateEnabled = false;
        }
    }

    protected List<LifecyclePolicyConfig> getPolicyConfigs() {
        if (this.stackTemplateEnabled) {
            return Arrays.asList(LOGS_ILM_POLICY, METRICS_ILM_POLICY, SYNTHETICS_ILM_POLICY, ILM_7_DAYS_POLICY, ILM_30_DAYS_POLICY, ILM_90_DAYS_POLICY, ILM_180_DAYS_POLICY, ILM_365_DAYS_POLICY);
        }
        return Collections.emptyList();
    }

    protected List<IndexTemplateConfig> getComponentTemplateConfigs() {
        if (this.stackTemplateEnabled) {
            return Arrays.asList(DATA_STREAMS_MAPPINGS_COMPONENT_TEMPLATE, LOGS_MAPPINGS_COMPONENT_TEMPLATE, LOGS_SETTINGS_COMPONENT_TEMPLATE, METRICS_MAPPINGS_COMPONENT_TEMPLATE, METRICS_SETTINGS_COMPONENT_TEMPLATE, SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE, SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE);
        }
        return Collections.emptyList();
    }

    protected List<IndexTemplateConfig> getComposableTemplateConfigs() {
        if (this.stackTemplateEnabled) {
            return Arrays.asList(LOGS_INDEX_TEMPLATE, METRICS_INDEX_TEMPLATE, SYNTHETICS_INDEX_TEMPLATE);
        }
        return Collections.emptyList();
    }

    protected String getOrigin() {
        return "stack";
    }

    protected boolean requiresMasterNode() {
        return true;
    }
}

