/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;

public class DateUtils {
    private static final DateFormatter dateOnlyFormatter = DateFormatter.forPattern((String)"yyyy-MM-dd").withZone((ZoneId)ZoneOffset.UTC);
    private static final DateFormatter dateTimeFormatter = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);

    public static long endOfTheDay(String date) {
        try {
            return dateTimeFormatter.parseMillis(date);
        }
        catch (IllegalArgumentException | ElasticsearchParseException ex) {
            ZonedDateTime dateTime = DateFormatters.from((TemporalAccessor)dateOnlyFormatter.parse(date));
            dateTime.with(ChronoField.MILLI_OF_DAY, ChronoField.MILLI_OF_DAY.range().getMaximum());
            return dateTime.toInstant().toEpochMilli();
        }
    }

    public static long beginningOfTheDay(String date) {
        try {
            return dateTimeFormatter.parseMillis(date);
        }
        catch (IllegalArgumentException | ElasticsearchParseException ex) {
            return DateFormatters.from((TemporalAccessor)dateOnlyFormatter.parse(date)).toInstant().toEpochMilli();
        }
    }
}

