/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.inference;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.ml.extractor.ExtractedField;
import org.elasticsearch.xpack.ml.extractor.ExtractedFields;
import org.elasticsearch.xpack.ml.utils.persistence.SearchAfterDocumentsIterator;

public class TestDocsIterator
extends SearchAfterDocumentsIterator<SearchHit> {
    private final DataFrameAnalyticsConfig config;
    private Long lastDocId;
    private final Map<String, String> docValueFieldAndFormatPairs;

    TestDocsIterator(OriginSettingClient client, DataFrameAnalyticsConfig config, ExtractedFields extractedFields, Long lastIncrementalId) {
        super(client, config.getDest().getIndex(), true);
        this.config = Objects.requireNonNull(config);
        this.docValueFieldAndFormatPairs = TestDocsIterator.buildDocValueFieldAndFormatPairs(extractedFields);
        this.lastDocId = lastIncrementalId;
    }

    private static Map<String, String> buildDocValueFieldAndFormatPairs(ExtractedFields extractedFields) {
        HashMap<String, String> docValueFieldAndFormatPairs = new HashMap<String, String>();
        for (ExtractedField docValueField : extractedFields.getDocValueFields()) {
            docValueFieldAndFormatPairs.put(docValueField.getSearchField(), docValueField.getDocValueFormat());
        }
        return docValueFieldAndFormatPairs;
    }

    @Override
    protected QueryBuilder getQuery() {
        return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)(this.config.getDest().getResultsField() + "." + "is_training"), (boolean)true));
    }

    @Override
    protected FieldSortBuilder sortField() {
        return (FieldSortBuilder)SortBuilders.fieldSort((String)"ml__incremental_id").order(SortOrder.ASC);
    }

    @Override
    protected SearchHit map(SearchHit hit) {
        return hit;
    }

    @Override
    protected Object[] searchAfterFields() {
        Object[] objectArray;
        if (this.lastDocId == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.lastDocId;
        }
        return objectArray;
    }

    @Override
    protected void extractSearchAfterFields(SearchHit lastSearchHit) {
        this.lastDocId = (long)((Long)lastSearchHit.getSortValues()[0]);
    }

    @Override
    protected SearchResponse executeSearchRequest(SearchRequest searchRequest) {
        return (SearchResponse)ClientHelper.executeWithHeaders((Map)this.config.getHeaders(), (String)"ml", (Client)this.client(), () -> (SearchResponse)this.client().search(searchRequest).actionGet());
    }

    @Override
    protected Map<String, String> docValueFieldAndFormatPairs() {
        return this.docValueFieldAndFormatPairs;
    }
}

