/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.ssl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.common.ssl.KeyStoreUtil;
import org.elasticsearch.common.ssl.PemUtils;
import org.elasticsearch.common.ssl.SslConfigException;
import org.elasticsearch.common.ssl.SslTrustConfig;

public final class PemTrustConfig
implements SslTrustConfig {
    private final List<Path> certificateAuthorities;

    public PemTrustConfig(List<Path> certificateAuthorities) {
        this.certificateAuthorities = Collections.unmodifiableList(certificateAuthorities);
    }

    @Override
    public Collection<Path> getDependentFiles() {
        return this.certificateAuthorities;
    }

    @Override
    public X509ExtendedTrustManager createTrustManager() {
        try {
            List<Certificate> certificates = this.loadCertificates();
            KeyStore store = KeyStoreUtil.buildTrustStore(certificates);
            return KeyStoreUtil.createTrustManager(store, TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (GeneralSecurityException e) {
            throw new SslConfigException("cannot create trust using PEM certificates [" + this.caPathsAsString() + "]", e);
        }
    }

    private List<Certificate> loadCertificates() throws CertificateException {
        try {
            return PemUtils.readCertificates(this.certificateAuthorities);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new SslConfigException("cannot configure trust using PEM certificates [" + this.caPathsAsString() + "] because one or more files do not exist", e);
        }
        catch (IOException e) {
            throw new SslConfigException("cannot configure trust using PEM certificates [" + this.caPathsAsString() + "] because one or more files cannot be read", e);
        }
    }

    public String toString() {
        return "PEM-trust{" + this.caPathsAsString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PemTrustConfig that = (PemTrustConfig)o;
        return Objects.equals(this.certificateAuthorities, that.certificateAuthorities);
    }

    public int hashCode() {
        return Objects.hash(this.certificateAuthorities);
    }

    private String caPathsAsString() {
        return this.certificateAuthorities.stream().map(Path::toAbsolutePath).map(Object::toString).collect(Collectors.joining(","));
    }
}

