/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.execution.search.extractor;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;

public class ConstantExtractor
implements HitExtractor,
BucketExtractor {
    static final String NAME = "c";
    private final Object constant;

    public ConstantExtractor(Object constant) {
        this.constant = constant;
    }

    ConstantExtractor(StreamInput in) throws IOException {
        this.constant = in.readGenericValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.constant);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object extract(SearchHit hit) {
        return this.constant;
    }

    @Override
    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        return this.constant;
    }

    @Override
    public String hitName() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConstantExtractor other = (ConstantExtractor)obj;
        return Objects.equals(this.constant, other.constant);
    }

    public int hashCode() {
        return Objects.hashCode(this.constant);
    }

    public String toString() {
        return "^" + this.constant;
    }
}

