/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.querydsl.query;

import java.util.Objects;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.ql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.ql.tree.Source;

public class GeoDistanceQuery
extends LeafQuery {
    private final String field;
    private final double lat;
    private final double lon;
    private final double distance;

    public GeoDistanceQuery(Source source, String field, double distance, double lat, double lon) {
        super(source);
        this.field = field;
        this.distance = distance;
        this.lat = lat;
        this.lon = lon;
    }

    public String field() {
        return this.field;
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public double distance() {
        return this.distance;
    }

    @Override
    public QueryBuilder asBuilder() {
        return QueryBuilders.geoDistanceQuery((String)this.field).distance(this.distance, DistanceUnit.METERS).point(this.lat, this.lon);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.distance, this.lat, this.lon);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoDistanceQuery other = (GeoDistanceQuery)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.distance, other.distance) && Objects.equals(this.lat, other.lat) && Objects.equals(this.lon, other.lon);
    }

    @Override
    protected String innerToString() {
        return this.field + ":(" + this.distance + ",(" + this.lat + ", " + this.lon + "))";
    }
}

