/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.index.SequentialStoredFieldsLeafReader;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.XContentType;

public class SourceLookup
implements Map<String, Object> {
    private LeafReader reader;
    CheckedBiConsumer<Integer, FieldsVisitor, IOException> fieldReader;
    private int docId = -1;
    private BytesReference sourceAsBytes;
    private Map<String, Object> source;
    private XContentType sourceContentType;

    public XContentType sourceContentType() {
        return this.sourceContentType;
    }

    public int docId() {
        return this.docId;
    }

    public Map<String, Object> source() {
        if (this.source != null) {
            return this.source;
        }
        if (this.sourceAsBytes != null) {
            Tuple<XContentType, Map<String, Object>> tuple = SourceLookup.sourceAsMapAndType(this.sourceAsBytes);
            this.sourceContentType = tuple.v1();
            this.source = tuple.v2();
            return this.source;
        }
        try {
            FieldsVisitor sourceFieldVisitor = new FieldsVisitor(true);
            this.fieldReader.accept(this.docId, sourceFieldVisitor);
            BytesReference source = sourceFieldVisitor.source();
            if (source == null) {
                this.source = Collections.emptyMap();
                this.sourceContentType = null;
            } else {
                Tuple<XContentType, Map<String, Object>> tuple = SourceLookup.sourceAsMapAndType(source);
                this.sourceContentType = tuple.v1();
                this.source = tuple.v2();
            }
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("failed to parse / load source", (Throwable)e, new Object[0]);
        }
        return this.source;
    }

    private static Tuple<XContentType, Map<String, Object>> sourceAsMapAndType(BytesReference source) throws ElasticsearchParseException {
        return XContentHelper.convertToMap(source, false);
    }

    public static Map<String, Object> sourceAsMap(BytesReference source) throws ElasticsearchParseException {
        return SourceLookup.sourceAsMapAndType(source).v2();
    }

    public void setSegmentAndDocument(LeafReaderContext context, int docId) {
        if (this.reader == context.reader() && this.docId == docId) {
            return;
        }
        if (this.reader != context.reader()) {
            this.reader = context.reader();
            if (context.reader() instanceof SequentialStoredFieldsLeafReader) {
                SequentialStoredFieldsLeafReader lf = (SequentialStoredFieldsLeafReader)context.reader();
                this.fieldReader = lf.getSequentialStoredFieldsReader()::visitDocument;
            } else {
                this.fieldReader = context.reader()::document;
            }
        }
        this.source = null;
        this.sourceAsBytes = null;
        this.docId = docId;
    }

    public void setSource(BytesReference source) {
        this.sourceAsBytes = source;
    }

    public void setSourceContentType(XContentType sourceContentType) {
        this.sourceContentType = sourceContentType;
    }

    public void setSource(Map<String, Object> source) {
        this.source = source;
    }

    public BytesReference internalSourceRef() {
        return this.sourceAsBytes;
    }

    public List<Object> extractRawValues(String path) {
        return XContentMapValues.extractRawValues(path, this.source());
    }

    public Object extractValue(String path, @Nullable Object nullValue) {
        return XContentMapValues.extractValue(path, this.source(), nullValue);
    }

    public Object filter(FetchSourceContext context) {
        return context.getFilter().apply(this.source());
    }

    @Override
    public Object get(Object key) {
        return this.source().get(key);
    }

    @Override
    public int size() {
        return this.source().size();
    }

    @Override
    public boolean isEmpty() {
        return this.source().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.source().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.source().containsValue(value);
    }

    @Override
    public Set<String> keySet() {
        return this.source().keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.source().values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.source().entrySet();
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

