/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.CompletableContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4TcpChannel
implements TcpChannel {
    private final Channel channel;
    private final boolean isServer;
    private final String profile;
    private final CompletableContext<Void> connectContext;
    private final CompletableContext<Void> closeContext = new CompletableContext();
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();

    Netty4TcpChannel(Channel channel, boolean isServer, String profile, @Nullable ChannelFuture connectFuture) {
        this.channel = channel;
        this.isServer = isServer;
        this.profile = profile;
        this.connectContext = new CompletableContext();
        Netty4TcpChannel.addListener(this.channel.closeFuture(), this.closeContext);
        Netty4TcpChannel.addListener(connectFuture, this.connectContext);
    }

    public static void addListener(ChannelFuture channelFuture, CompletableContext<Void> context) {
        channelFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                context.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread(cause);
                    context.completeExceptionally(new Exception(cause));
                } else {
                    context.completeExceptionally((Exception)cause);
                }
            }
        }));
    }

    public static ChannelPromise addPromise(ActionListener<Void> listener, Channel channel) {
        ChannelPromise writePromise = channel.newPromise();
        writePromise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                ExceptionsHelper.maybeDieOnAnotherThread(cause);
                if (cause instanceof Error) {
                    listener.onFailure(new Exception(cause));
                } else {
                    listener.onFailure((Exception)cause);
                }
            }
        }));
        return writePromise;
    }

    @Override
    public void close() {
        this.channel.close();
    }

    @Override
    public boolean isServerChannel() {
        return this.isServer;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(ActionListener.toBiConsumer(listener));
    }

    @Override
    public void addConnectListener(ActionListener<Void> listener) {
        this.connectContext.addListener(ActionListener.toBiConsumer(listener));
    }

    @Override
    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        this.channel.writeAndFlush(Netty4Utils.toByteBuf(reference), Netty4TcpChannel.addPromise(listener, this.channel));
        if (this.channel.eventLoop().isShutdown()) {
            listener.onFailure(new TransportException("Cannot send message, event loop is shutting down."));
        }
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    public String toString() {
        return "Netty4TcpChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.channel.remoteAddress() + ", profile=" + this.profile + '}';
    }
}

