/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action;

import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestToXContentListener<Response extends ToXContentObject>
extends RestBuilderListener<Response> {
    public RestToXContentListener(RestChannel channel) {
        super(channel);
    }

    @Override
    public RestResponse buildResponse(Response response, XContentBuilder builder) throws Exception {
        assert (!response.isFragment());
        response.toXContent(builder, (ToXContent.Params)this.channel.request());
        return new BytesRestResponse(this.getStatus(response), builder);
    }

    protected RestStatus getStatus(Response response) {
        return RestStatus.OK;
    }

    @Override
    boolean assertBuilderClosed(XContentBuilder xContentBuilder) {
        assert (xContentBuilder.generator().isClosed()) : "callers should ensure the XContentBuilder is closed themselves";
        return true;
    }
}

