/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoFormatterFactory;
import org.elasticsearch.common.geo.GeoShapeUtils;
import org.elasticsearch.common.geo.GeometryParser;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.GeoShapeParser;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.legacygeo.mapper.LegacyGeoShapeFieldMapper;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xpack.spatial.index.fielddata.plain.AbstractLatLonShapeIndexFieldData;
import org.elasticsearch.xpack.spatial.index.mapper.BinaryGeoShapeDocValuesField;
import org.elasticsearch.xpack.spatial.index.mapper.LatLonShapeDocValuesQuery;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSourceType;

public class GeoShapeWithDocValuesFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry> {
    public static final String CONTENT_TYPE = "geo_shape";
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(GeoShapeFieldMapper.class);
    private final Builder builder;
    private final GeoShapeIndexer indexer;

    private static Builder builder(FieldMapper in) {
        return ((GeoShapeWithDocValuesFieldMapper)in).builder;
    }

    public GeoShapeWithDocValuesFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, GeoShapeIndexer indexer, GeoShapeParser parser, Builder builder) {
        super(simpleName, mappedFieldType, (Explicit)builder.ignoreMalformed.get(), (Explicit)builder.coerce.get(), (Explicit)builder.ignoreZValue.get(), (Explicit)builder.orientation.get(), multiFields, copyTo, (AbstractGeometryFieldMapper.Parser)parser);
        this.builder = builder;
        this.indexer = indexer;
    }

    protected void index(DocumentParserContext context, Geometry geometry) throws IOException {
        if (geometry == null) {
            return;
        }
        geometry = this.indexer.prepareForIndexing(geometry);
        List fields = this.indexer.indexShape(geometry);
        if (this.fieldType().isSearchable()) {
            context.doc().addAll(fields);
        }
        if (this.fieldType().hasDocValues()) {
            String name = this.fieldType().name();
            BinaryGeoShapeDocValuesField docValuesField = (BinaryGeoShapeDocValuesField)context.doc().getByKey((Object)name);
            if (docValuesField == null) {
                docValuesField = new BinaryGeoShapeDocValuesField(name);
                context.doc().addWithKey((Object)name, (IndexableField)docValuesField);
            }
            docValuesField.add(fields, geometry);
        } else if (this.fieldType().isSearchable()) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.version, (Boolean)((Explicit)this.builder.ignoreMalformed.getDefaultValue()).value(), (Boolean)((Explicit)this.builder.coerce.getDefaultValue()).value(), (GeoFormatterFactory<Geometry>)this.builder.geoFormatterFactory).init((FieldMapper)this);
    }

    public GeoShapeWithDocValuesFieldType fieldType() {
        return (GeoShapeWithDocValuesFieldType)super.fieldType();
    }

    protected void checkIncomingMergeType(FieldMapper mergeWith) {
        if (!(mergeWith instanceof GeoShapeWithDocValuesFieldMapper) && CONTENT_TYPE.equals(mergeWith.typeName())) {
            throw new IllegalArgumentException("mapper [" + this.name() + "] of type [geo_shape] cannot change strategy from [BKD] to [recursive]");
        }
        super.checkIncomingMergeType(mergeWith);
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> (Boolean)GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).indexed.get(), (boolean)true);
        final FieldMapper.Parameter<Boolean> hasDocValues;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> (Explicit)GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        final FieldMapper.Parameter<Explicit<Orientation>> orientation = AbstractShapeGeometryFieldMapper.orientationParam(m -> (Explicit)GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).orientation.get());
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final Version version;
        private final GeoFormatterFactory<Geometry> geoFormatterFactory;

        public Builder(String name, Version version, boolean ignoreMalformedByDefault, boolean coerceByDefault, GeoFormatterFactory<Geometry> geoFormatterFactory) {
            super(name);
            this.version = version;
            this.geoFormatterFactory = geoFormatterFactory;
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> (Explicit)GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), (boolean)ignoreMalformedByDefault);
            this.coerce = AbstractShapeGeometryFieldMapper.coerceParam(m -> (Explicit)GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).coerce.get(), (boolean)coerceByDefault);
            this.hasDocValues = FieldMapper.Parameter.docValuesParam(m -> (Boolean)GeoShapeWithDocValuesFieldMapper.builder((FieldMapper)m).hasDocValues.get(), (boolean)Version.V_7_8_0.onOrBefore(version));
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.ignoreMalformed, this.ignoreZValue, this.coerce, this.orientation, this.meta);
        }

        public GeoShapeWithDocValuesFieldMapper build(MapperBuilderContext context) {
            if (this.multiFieldsBuilder.hasMultiFields()) {
                DEPRECATION_LOGGER.warn(DeprecationCategory.MAPPINGS, "geo_shape_multifields", "Adding multifields to [geo_shape] mappers has no effect and will be forbidden in future", new Object[0]);
            }
            GeometryParser geometryParser = new GeometryParser(((Orientation)((Explicit)this.orientation.get()).value()).getAsBoolean(), ((Boolean)((Explicit)this.coerce.get()).value()).booleanValue(), ((Boolean)((Explicit)this.ignoreZValue.get()).value()).booleanValue());
            GeoShapeParser parser = new GeoShapeParser(geometryParser);
            GeoShapeWithDocValuesFieldType ft = new GeoShapeWithDocValuesFieldType(context.buildFullName(this.name), (Boolean)this.indexed.get(), (Boolean)this.hasDocValues.get(), (Orientation)((Explicit)this.orientation.get()).value(), parser, this.geoFormatterFactory, (Map)this.meta.get());
            return new GeoShapeWithDocValuesFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), new GeoShapeIndexer(((Orientation)((Explicit)this.orientation.get()).value()).getAsBoolean(), ft.name()), parser, this);
        }
    }

    public static final class GeoShapeWithDocValuesFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType<Geometry>
    implements GeoShapeQueryable {
        private final GeoFormatterFactory<Geometry> geoFormatterFactory;

        public GeoShapeWithDocValuesFieldType(String name, boolean indexed, boolean hasDocValues, Orientation orientation, GeoShapeParser parser, GeoFormatterFactory<Geometry> geoFormatterFactory, Map<String, String> meta) {
            super(name, indexed, false, hasDocValues, (AbstractGeometryFieldMapper.Parser)parser, orientation, meta);
            this.geoFormatterFactory = geoFormatterFactory;
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new AbstractLatLonShapeIndexFieldData.Builder(this.name(), GeoShapeValuesSourceType.instance());
        }

        public String typeName() {
            return GeoShapeWithDocValuesFieldMapper.CONTENT_TYPE;
        }

        public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before(Version.V_7_5_0)) {
                throw new QueryShardException(context, ShapeRelation.CONTAINS + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
            }
            LatLonGeometry[] luceneGeometries = GeoShapeUtils.toLuceneGeometry((String)fieldName, (SearchExecutionContext)context, (Geometry)shape, (ShapeRelation)relation);
            if (luceneGeometries.length == 0) {
                return new MatchNoDocsQuery();
            }
            Query query = LatLonShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (LatLonGeometry[])luceneGeometries);
            if (this.hasDocValues()) {
                LatLonShapeDocValuesQuery queryDocValues = new LatLonShapeDocValuesQuery(fieldName, relation.getLuceneRelation(), luceneGeometries);
                query = new IndexOrDocValuesQuery(query, (Query)queryDocValues);
            }
            return query;
        }

        protected Function<List<Geometry>, List<Object>> getFormatter(String format) {
            return this.geoFormatterFactory.getFormatter(format, Function.identity());
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private final GeoFormatterFactory<Geometry> geoFormatterFactory;

        public TypeParser(GeoFormatterFactory<Geometry> geoFormatterFactory) {
            this.geoFormatterFactory = geoFormatterFactory;
        }

        public Mapper.Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            boolean ignoreMalformedByDefault = (Boolean)FieldMapper.IGNORE_MALFORMED_SETTING.get(parserContext.getSettings());
            boolean coerceByDefault = (Boolean)FieldMapper.COERCE_SETTING.get(parserContext.getSettings());
            Object builder = parserContext.indexVersionCreated().before(Version.V_6_6_0) || LegacyGeoShapeFieldMapper.containsDeprecatedParameter(node.keySet()) ? new LegacyGeoShapeFieldMapper.Builder(name, parserContext.indexVersionCreated(), ignoreMalformedByDefault, coerceByDefault) : new Builder(name, parserContext.indexVersionCreated(), ignoreMalformedByDefault, coerceByDefault, this.geoFormatterFactory);
            builder.parse(name, parserContext, node);
            return builder;
        }
    }
}

