/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncResponse;
import org.elasticsearch.xpack.core.async.AsyncTask;
import org.elasticsearch.xpack.core.async.GetAsyncStatusRequest;
import org.elasticsearch.xpack.core.search.action.SearchStatusResponse;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;

public final class AsyncTaskIndexService<R extends AsyncResponse<R>> {
    private static final Logger logger = LogManager.getLogger(AsyncTaskIndexService.class);
    public static final String HEADERS_FIELD = "headers";
    public static final String RESPONSE_HEADERS_FIELD = "response_headers";
    public static final String EXPIRATION_TIME_FIELD = "expiration_time";
    public static final String RESULT_FIELD = "result";
    private final String index;
    private final ClusterService clusterService;
    private final Client client;
    private final Client clientWithOrigin;
    private final SecurityContext securityContext;
    private final NamedWriteableRegistry registry;
    private final Writeable.Reader<R> reader;
    private final BigArrays bigArrays;
    private final CircuitBreaker circuitBreaker;
    private volatile long maxResponseSize;

    static Settings settings() {
        return Settings.builder().put("index.codec", "best_compression").put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-1").build();
    }

    static XContentBuilder mappings() throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("_meta").field("version", (ToXContent)Version.CURRENT).endObject().field("dynamic", "strict").startObject("properties").startObject(HEADERS_FIELD).field("type", "object").field("enabled", "false").endObject().startObject(RESPONSE_HEADERS_FIELD).field("type", "object").field("enabled", "false").endObject().startObject(RESULT_FIELD).field("type", "object").field("enabled", "false").endObject().startObject(EXPIRATION_TIME_FIELD).field("type", "long").endObject().endObject().endObject().endObject();
        return builder;
    }

    public AsyncTaskIndexService(String index, ClusterService clusterService, ThreadContext threadContext, Client client, String origin, Writeable.Reader<R> reader, NamedWriteableRegistry registry, BigArrays bigArrays) {
        this.index = index;
        this.clusterService = clusterService;
        this.securityContext = new SecurityContext(clusterService.getSettings(), threadContext);
        this.client = client;
        this.clientWithOrigin = new OriginSettingClient(client, origin);
        this.registry = registry;
        this.reader = reader;
        this.bigArrays = bigArrays;
        this.circuitBreaker = bigArrays.breakerService().getBreaker("request");
        this.maxResponseSize = ((ByteSizeValue)SearchService.MAX_ASYNC_SEARCH_RESPONSE_SIZE_SETTING.get(clusterService.getSettings())).getBytes();
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SearchService.MAX_ASYNC_SEARCH_RESPONSE_SIZE_SETTING, v -> {
            this.maxResponseSize = v.getBytes();
        });
    }

    public Client getClientWithOrigin() {
        return this.clientWithOrigin;
    }

    public Client getClient() {
        return this.client;
    }

    void createIndexIfNecessary(ActionListener<Void> listener) {
        if (!this.clusterService.state().routingTable().hasIndex(this.index)) {
            try {
                this.clientWithOrigin.admin().indices().prepareCreate(this.index).setSettings(AsyncTaskIndexService.settings()).addMapping("_doc", AsyncTaskIndexService.mappings()).execute(ActionListener.wrap(resp -> listener.onResponse(null), exc -> {
                    if (ExceptionsHelper.unwrapCause((Throwable)exc) instanceof ResourceAlreadyExistsException) {
                        listener.onResponse(null);
                    } else {
                        logger.error("failed to create " + this.index + " index", (Throwable)exc);
                        listener.onFailure(exc);
                    }
                }));
            }
            catch (Exception exc2) {
                logger.error("failed to create " + this.index + " index", (Throwable)exc2);
                listener.onFailure(exc2);
            }
        } else {
            listener.onResponse(null);
        }
    }

    public Authentication getAuthentication() {
        return this.securityContext.getAuthentication();
    }

    public void createResponseForEQL(String docId, Map<String, String> headers, R response, ActionListener<IndexResponse> outerListener) throws IOException {
        this.createIndexIfNecessary((ActionListener<Void>)outerListener.delegateFailure((listener, ignored) -> {
            try {
                ReleasableBytesStreamOutput buffer = new ReleasableBytesStreamOutput(0, this.bigArrays.withCircuitBreaking());
                XContentBuilder source = XContentFactory.jsonBuilder((OutputStream)buffer);
                listener = ActionListener.runBefore((ActionListener)listener, () -> ((ReleasableBytesStreamOutput)buffer).close());
                source.startObject().field(HEADERS_FIELD, (Object)headers).field(EXPIRATION_TIME_FIELD, response.getExpirationTime()).directFieldAsBase64(RESULT_FIELD, os -> this.writeResponse(response, (OutputStream)os)).endObject();
                source.flush();
                IndexRequest indexRequest = new IndexRequest(this.index).create(true).id(docId).source(buffer.bytes(), source.contentType());
                this.clientWithOrigin.index(indexRequest, listener);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }));
    }

    public void createResponse(String docId, Map<String, String> headers, R response, ActionListener<IndexResponse> outerListener) throws IOException {
        this.createIndexIfNecessary((ActionListener<Void>)outerListener.delegateFailure((listener, ignored) -> {
            try {
                ReleasableBytesStreamOutputWithLimit buffer = this.maxResponseSize > -1L ? new ReleasableBytesStreamOutputWithLimit(0, this.bigArrays.withCircuitBreaking(), this.maxResponseSize) : new ReleasableBytesStreamOutput(0, this.bigArrays.withCircuitBreaking());
                XContentBuilder source = XContentFactory.jsonBuilder((OutputStream)((Object)buffer));
                listener = ActionListener.runBefore((ActionListener)listener, () -> ((ReleasableBytesStreamOutput)buffer).close());
                source.startObject().field(HEADERS_FIELD, (Object)headers).field(EXPIRATION_TIME_FIELD, response.getExpirationTime()).directFieldAsBase64(RESULT_FIELD, os -> this.writeResponse(response, (OutputStream)os)).endObject();
                source.flush();
                IndexRequest indexRequest = new IndexRequest(this.index).create(true).id(docId).source(buffer.bytes(), source.contentType());
                this.clientWithOrigin.index(indexRequest, listener);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }));
    }

    public void updateResponse(String docId, Map<String, List<String>> responseHeaders, R response, ActionListener<UpdateResponse> listener) {
        this.updateResponse(docId, responseHeaders, response, listener, false);
    }

    public void updateResponse(String docId, Map<String, List<String>> responseHeaders, R response, ActionListener<UpdateResponse> outerListener, boolean isFailure) {
        this.createIndexIfNecessary((ActionListener<Void>)outerListener.delegateFailure((listener, ignored) -> {
            try {
                ReleasableBytesStreamOutput buffer = !isFailure && this.maxResponseSize > -1L ? new ReleasableBytesStreamOutputWithLimit(0, this.bigArrays.withCircuitBreaking(), this.maxResponseSize) : new ReleasableBytesStreamOutput(0, this.bigArrays.withCircuitBreaking());
                XContentBuilder source = XContentFactory.jsonBuilder((OutputStream)buffer);
                listener = ActionListener.runBefore((ActionListener)listener, () -> ((ReleasableBytesStreamOutput)buffer).close());
                source.startObject().field(RESPONSE_HEADERS_FIELD, (Object)responseHeaders).directFieldAsBase64(RESULT_FIELD, os -> this.writeResponse(response, (OutputStream)os)).endObject();
                source.flush();
                UpdateRequest request = ((UpdateRequest)new UpdateRequest().index(this.index)).id(docId).doc(buffer.bytes(), source.contentType()).retryOnConflict(5);
                this.clientWithOrigin.update(request, listener);
            }
            catch (Exception e) {
                if (isFailure) {
                    listener.onFailure(e);
                }
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                if (!(cause instanceof DocumentMissingException) && !(cause instanceof VersionConflictEngineException)) {
                    logger.error(() -> new ParameterizedMessage("failed to store async-search [{}]", (Object)docId), (Throwable)e);
                    ActionListener newListener = listener;
                    this.updateStoredResponseWithFailure(docId, responseHeaders, response, e, (ActionListener<UpdateResponse>)ActionListener.wrap(() -> newListener.onFailure(e)));
                }
                listener.onFailure(e);
            }
        }));
    }

    private void updateStoredResponseWithFailure(String docId, Map<String, List<String>> responseHeaders, R response, Exception updateException, ActionListener<UpdateResponse> listener) {
        Object failureResponse = response.convertToFailure(updateException);
        this.updateResponse(docId, responseHeaders, failureResponse, listener, true);
    }

    public void updateExpirationTime(String docId, long expirationTimeMillis, ActionListener<UpdateResponse> listener) {
        Map<String, Long> source = Collections.singletonMap(EXPIRATION_TIME_FIELD, expirationTimeMillis);
        UpdateRequest request = ((UpdateRequest)new UpdateRequest().index(this.index)).id(docId).doc(source, XContentType.JSON).retryOnConflict(5);
        this.createIndexIfNecessary((ActionListener<Void>)ActionListener.wrap(v -> this.clientWithOrigin.update(request, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    public void deleteResponse(AsyncExecutionId asyncExecutionId, ActionListener<DeleteResponse> listener) {
        try {
            DeleteRequest request = new DeleteRequest(this.index).id(asyncExecutionId.getDocId());
            this.createIndexIfNecessary((ActionListener<Void>)ActionListener.wrap(v -> this.clientWithOrigin.delete(request, listener), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public <T extends AsyncTask> T getTask(TaskManager taskManager, AsyncExecutionId asyncExecutionId, Class<T> tClass) throws IOException {
        Task task = taskManager.getTask(asyncExecutionId.getTaskId().getId());
        if (!tClass.isInstance(task)) {
            return null;
        }
        AsyncTask asyncTask = (AsyncTask)task;
        if (!asyncTask.getExecutionId().equals(asyncExecutionId)) {
            return null;
        }
        return (T)asyncTask;
    }

    public <T extends AsyncTask> T getTaskAndCheckAuthentication(TaskManager taskManager, AsyncExecutionId asyncExecutionId, Class<T> tClass) throws IOException {
        T asyncTask = this.getTask(taskManager, asyncExecutionId, tClass);
        if (asyncTask == null) {
            return null;
        }
        Authentication auth = this.securityContext.getAuthentication();
        if (!this.ensureAuthenticatedUserIsSame(asyncTask.getOriginHeaders(), auth)) {
            throw new ResourceNotFoundException(asyncExecutionId.getEncoded() + " not found", new Object[0]);
        }
        return asyncTask;
    }

    public void getResponse(AsyncExecutionId asyncExecutionId, boolean restoreResponseHeaders, ActionListener<R> listener) {
        this.getResponseFromIndex(asyncExecutionId, restoreResponseHeaders, true, listener);
    }

    private void getResponseFromIndex(AsyncExecutionId asyncExecutionId, boolean restoreResponseHeaders, boolean checkAuthentication, ActionListener<R> outerListener) {
        GetRequest getRequest = new GetRequest(this.index).preference(asyncExecutionId.getEncoded()).id(asyncExecutionId.getDocId()).realtime(true);
        this.clientWithOrigin.get(getRequest, outerListener.delegateFailure((listener, getResponse) -> {
            R resp;
            if (!getResponse.isExists()) {
                listener.onFailure((Exception)new ResourceNotFoundException(asyncExecutionId.getEncoded(), new Object[0]));
                return;
            }
            try {
                BytesReference source = getResponse.getSourceInternal();
                int reservedBytes = source.length() * 2;
                this.circuitBreaker.addEstimateBytesAndMaybeBreak((long)source.length() * 2L, "decode async response");
                listener = ActionListener.runAfter((ActionListener)listener, () -> this.circuitBreaker.addWithoutBreaking((long)(-reservedBytes)));
                resp = this.parseResponseFromIndex(asyncExecutionId, source, restoreResponseHeaders, checkAuthentication);
            }
            catch (Exception e) {
                listener.onFailure(e);
                return;
            }
            listener.onResponse(resp);
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private R parseResponseFromIndex(AsyncExecutionId asyncExecutionId, BytesReference source, boolean restoreResponseHeaders, boolean checkAuthentication) {
        try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)source, (XContentType)XContentType.JSON);){
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)parser.nextToken(), (XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser)parser);
            AsyncResponse<Object> resp = null;
            Long expirationTime = null;
            block19: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                parser.nextToken();
                switch (parser.currentName()) {
                    case "result": {
                        resp = this.decodeResponse(parser.charBuffer());
                        continue block19;
                    }
                    case "expiration_time": {
                        expirationTime = (long)((Long)parser.numberValue());
                        continue block19;
                    }
                    case "headers": {
                        Map headers = (Map)XContentParserUtils.parseFieldsValue((XContentParser)parser);
                        if (!checkAuthentication || this.ensureAuthenticatedUserIsSame(headers, this.securityContext.getAuthentication())) continue block19;
                        throw new ResourceNotFoundException(asyncExecutionId.getEncoded(), new Object[0]);
                    }
                    case "response_headers": {
                        Map responseHeaders = (Map)XContentParserUtils.parseFieldsValue((XContentParser)parser);
                        if (!restoreResponseHeaders) continue block19;
                        AsyncTaskIndexService.restoreResponseHeadersContext(this.securityContext.getThreadContext(), responseHeaders);
                        continue block19;
                    }
                }
                XContentParserUtils.parseFieldsValue((XContentParser)parser);
            }
            Objects.requireNonNull(resp, "Get result doesn't include [result] field");
            Objects.requireNonNull(expirationTime, "Get result doesn't include [expiration_time] field");
            String string = resp.withExpirationTime(expirationTime);
            return (R)string;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to parse the get result", (Throwable)e, new Object[0]);
        }
    }

    public <T extends AsyncTask, SR extends SearchStatusResponse> void retrieveStatus(GetAsyncStatusRequest request, TaskManager taskManager, Class<T> tClass, Function<T, SR> statusProducerFromTask, TriFunction<R, Long, String, SR> statusProducerFromIndex, ActionListener<SR> outerListener) {
        outerListener = outerListener.delegateFailure((listener, resp) -> {
            if (resp.getExpirationTime() < System.currentTimeMillis()) {
                listener.onFailure((Exception)new ResourceNotFoundException(request.getId(), new Object[0]));
            } else {
                listener.onResponse(resp);
            }
        });
        AsyncExecutionId asyncExecutionId = AsyncExecutionId.decode(request.getId());
        try {
            T asyncTask = this.getTask(taskManager, asyncExecutionId, tClass);
            if (asyncTask != null) {
                SearchStatusResponse response = (SearchStatusResponse)statusProducerFromTask.apply(asyncTask);
                outerListener.onResponse((Object)response);
            } else {
                this.getResponseFromIndex(asyncExecutionId, false, false, outerListener.delegateFailure((listener, resp) -> listener.onResponse((Object)((SearchStatusResponse)statusProducerFromIndex.apply(resp, (Object)resp.getExpirationTime(), (Object)asyncExecutionId.getEncoded())))));
            }
        }
        catch (Exception exc) {
            outerListener.onFailure(exc);
        }
    }

    void ensureAuthenticatedUserCanDeleteFromIndex(AsyncExecutionId executionId, ActionListener<Void> listener) {
        GetRequest internalGet = new GetRequest(this.index).preference(executionId.getEncoded()).id(executionId.getDocId()).fetchSourceContext(new FetchSourceContext(true, new String[]{HEADERS_FIELD}, new String[0]));
        this.clientWithOrigin.get(internalGet, ActionListener.wrap(get -> {
            if (!get.isExists()) {
                listener.onFailure((Exception)new ResourceNotFoundException(executionId.getEncoded(), new Object[0]));
                return;
            }
            Map headers = (Map)get.getSource().get(HEADERS_FIELD);
            if (this.ensureAuthenticatedUserIsSame(headers, this.securityContext.getAuthentication())) {
                listener.onResponse(null);
            } else {
                listener.onFailure((Exception)new ResourceNotFoundException(executionId.getEncoded(), new Object[0]));
            }
        }, exc -> listener.onFailure((Exception)new ResourceNotFoundException(executionId.getEncoded(), new Object[0]))));
    }

    boolean ensureAuthenticatedUserIsSame(Map<String, String> originHeaders, Authentication current) throws IOException {
        if (originHeaders == null || !originHeaders.containsKey("_xpack_security_authentication")) {
            return true;
        }
        if (current == null) {
            return false;
        }
        Authentication origin = AuthenticationContextSerializer.decode(originHeaders.get("_xpack_security_authentication"));
        return origin.canAccessResourcesOf(current);
    }

    private void writeResponse(R response, OutputStream os) throws IOException {
        os = new FilterOutputStream(os){

            @Override
            public void close() {
            }
        };
        Version minNodeVersion = this.clusterService.state().nodes().getMinNodeVersion();
        Version.writeVersion((Version)minNodeVersion, (StreamOutput)new OutputStreamStreamOutput(os));
        if (minNodeVersion.onOrAfter(Version.V_7_15_0)) {
            os = CompressorFactory.COMPRESSOR.threadLocalOutputStream(os);
        }
        try (OutputStreamStreamOutput out = new OutputStreamStreamOutput(os);){
            out.setVersion(minNodeVersion);
            response.writeTo((StreamOutput)out);
        }
    }

    private R decodeResponse(final CharBuffer encodedBuffer) throws IOException {
        InputStream encodedIn = Base64.getDecoder().wrap(new InputStream(){

            @Override
            public int read() {
                if (encodedBuffer.hasRemaining()) {
                    return encodedBuffer.get();
                }
                return -1;
            }
        });
        Version version = Version.readVersion((StreamInput)new InputStreamStreamInput(encodedIn));
        assert (version.onOrBefore(Version.CURRENT)) : version + " >= " + Version.CURRENT;
        if (version.onOrAfter(Version.V_7_15_0)) {
            encodedIn = CompressorFactory.COMPRESSOR.threadLocalInputStream(encodedIn);
        }
        try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput((StreamInput)new InputStreamStreamInput(encodedIn), this.registry);){
            in.setVersion(version);
            AsyncResponse asyncResponse = (AsyncResponse)this.reader.read((StreamInput)in);
            return (R)asyncResponse;
        }
    }

    public static void restoreResponseHeadersContext(ThreadContext threadContext, Map<String, List<String>> responseHeaders) {
        for (Map.Entry<String, List<String>> entry : responseHeaders.entrySet()) {
            for (String value : entry.getValue()) {
                threadContext.addResponseHeader(entry.getKey(), value);
            }
        }
    }

    private static class ReleasableBytesStreamOutputWithLimit
    extends ReleasableBytesStreamOutput {
        private final long limit;

        ReleasableBytesStreamOutputWithLimit(int expectedSize, BigArrays bigArrays, long limit) {
            super(expectedSize, bigArrays);
            this.limit = limit;
        }

        protected void ensureCapacity(long offset) {
            if (offset > this.limit) {
                throw new IllegalArgumentException("Can't store an async search response larger than [" + this.limit + "] bytes. This limit can be set by changing the [" + SearchService.MAX_ASYNC_SEARCH_RESPONSE_SIZE_SETTING.getKey() + "] setting.");
            }
            super.ensureCapacity(offset);
        }
    }
}

