/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterStateUpdateStats
implements Writeable,
ToXContentFragment {
    private final long unchangedTaskCount;
    private final long publicationSuccessCount;
    private final long publicationFailureCount;
    private final long unchangedComputationElapsedMillis;
    private final long unchangedNotificationElapsedMillis;
    private final long successfulComputationElapsedMillis;
    private final long successfulPublicationElapsedMillis;
    private final long successfulContextConstructionElapsedMillis;
    private final long successfulCommitElapsedMillis;
    private final long successfulCompletionElapsedMillis;
    private final long successfulMasterApplyElapsedMillis;
    private final long successfulNotificationElapsedMillis;
    private final long failedComputationElapsedMillis;
    private final long failedPublicationElapsedMillis;
    private final long failedContextConstructionElapsedMillis;
    private final long failedCommitElapsedMillis;
    private final long failedCompletionElapsedMillis;
    private final long failedMasterApplyElapsedMillis;
    private final long failedNotificationElapsedMillis;
    public static ClusterStateUpdateStats EMPTY = new ClusterStateUpdateStats(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);

    public ClusterStateUpdateStats(long unchangedTaskCount, long publicationSuccessCount, long publicationFailureCount, long unchangedComputationElapsedMillis, long unchangedNotificationElapsedMillis, long successfulComputationElapsedMillis, long successfulPublicationElapsedMillis, long successfulContextConstructionElapsedMillis, long successfulCommitElapsedMillis, long successfulCompletionElapsedMillis, long successfulMasterApplyElapsedMillis, long successfulNotificationElapsedMillis, long failedComputationElapsedMillis, long failedPublicationElapsedMillis, long failedContextConstructionElapsedMillis, long failedCommitElapsedMillis, long failedCompletionElapsedMillis, long failedMasterApplyElapsedMillis, long failedNotificationElapsedMillis) {
        this.unchangedTaskCount = ClusterStateUpdateStats.nonNegative(unchangedTaskCount);
        this.publicationSuccessCount = ClusterStateUpdateStats.nonNegative(publicationSuccessCount);
        this.publicationFailureCount = ClusterStateUpdateStats.nonNegative(publicationFailureCount);
        this.unchangedComputationElapsedMillis = ClusterStateUpdateStats.nonNegative(unchangedComputationElapsedMillis);
        this.unchangedNotificationElapsedMillis = ClusterStateUpdateStats.nonNegative(unchangedNotificationElapsedMillis);
        this.successfulComputationElapsedMillis = ClusterStateUpdateStats.nonNegative(successfulComputationElapsedMillis);
        this.successfulPublicationElapsedMillis = ClusterStateUpdateStats.nonNegative(successfulPublicationElapsedMillis);
        this.successfulContextConstructionElapsedMillis = ClusterStateUpdateStats.nonNegative(successfulContextConstructionElapsedMillis);
        this.successfulCommitElapsedMillis = ClusterStateUpdateStats.nonNegative(successfulCommitElapsedMillis);
        this.successfulCompletionElapsedMillis = ClusterStateUpdateStats.nonNegative(successfulCompletionElapsedMillis);
        this.successfulMasterApplyElapsedMillis = ClusterStateUpdateStats.nonNegative(successfulMasterApplyElapsedMillis);
        this.successfulNotificationElapsedMillis = ClusterStateUpdateStats.nonNegative(successfulNotificationElapsedMillis);
        this.failedComputationElapsedMillis = ClusterStateUpdateStats.nonNegative(failedComputationElapsedMillis);
        this.failedPublicationElapsedMillis = ClusterStateUpdateStats.nonNegative(failedPublicationElapsedMillis);
        this.failedContextConstructionElapsedMillis = ClusterStateUpdateStats.nonNegative(failedContextConstructionElapsedMillis);
        this.failedCommitElapsedMillis = ClusterStateUpdateStats.nonNegative(failedCommitElapsedMillis);
        this.failedCompletionElapsedMillis = ClusterStateUpdateStats.nonNegative(failedCompletionElapsedMillis);
        this.failedMasterApplyElapsedMillis = ClusterStateUpdateStats.nonNegative(failedMasterApplyElapsedMillis);
        this.failedNotificationElapsedMillis = ClusterStateUpdateStats.nonNegative(failedNotificationElapsedMillis);
    }

    private static long nonNegative(long v) {
        assert (v >= 0L) : v;
        return v;
    }

    public ClusterStateUpdateStats(StreamInput in) throws IOException {
        this.unchangedTaskCount = in.readVLong();
        this.publicationSuccessCount = in.readVLong();
        this.publicationFailureCount = in.readVLong();
        this.unchangedComputationElapsedMillis = in.readVLong();
        this.unchangedNotificationElapsedMillis = in.readVLong();
        this.successfulComputationElapsedMillis = in.readVLong();
        this.successfulPublicationElapsedMillis = in.readVLong();
        this.successfulContextConstructionElapsedMillis = in.readVLong();
        this.successfulCommitElapsedMillis = in.readVLong();
        this.successfulCompletionElapsedMillis = in.readVLong();
        this.successfulMasterApplyElapsedMillis = in.readVLong();
        this.successfulNotificationElapsedMillis = in.readVLong();
        this.failedComputationElapsedMillis = in.readVLong();
        this.failedPublicationElapsedMillis = in.readVLong();
        this.failedContextConstructionElapsedMillis = in.readVLong();
        this.failedCommitElapsedMillis = in.readVLong();
        this.failedCompletionElapsedMillis = in.readVLong();
        this.failedMasterApplyElapsedMillis = in.readVLong();
        this.failedNotificationElapsedMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        assert (out.getVersion().onOrAfter(Version.V_7_16_0)) : out.getVersion();
        out.writeVLong(this.unchangedTaskCount);
        out.writeVLong(this.publicationSuccessCount);
        out.writeVLong(this.publicationFailureCount);
        out.writeVLong(this.unchangedComputationElapsedMillis);
        out.writeVLong(this.unchangedNotificationElapsedMillis);
        out.writeVLong(this.successfulComputationElapsedMillis);
        out.writeVLong(this.successfulPublicationElapsedMillis);
        out.writeVLong(this.successfulContextConstructionElapsedMillis);
        out.writeVLong(this.successfulCommitElapsedMillis);
        out.writeVLong(this.successfulCompletionElapsedMillis);
        out.writeVLong(this.successfulMasterApplyElapsedMillis);
        out.writeVLong(this.successfulNotificationElapsedMillis);
        out.writeVLong(this.failedComputationElapsedMillis);
        out.writeVLong(this.failedPublicationElapsedMillis);
        out.writeVLong(this.failedContextConstructionElapsedMillis);
        out.writeVLong(this.failedCommitElapsedMillis);
        out.writeVLong(this.failedCompletionElapsedMillis);
        out.writeVLong(this.failedMasterApplyElapsedMillis);
        out.writeVLong(this.failedNotificationElapsedMillis);
    }

    public long getUnchangedTaskCount() {
        return this.unchangedTaskCount;
    }

    public long getPublicationSuccessCount() {
        return this.publicationSuccessCount;
    }

    public long getPublicationFailureCount() {
        return this.publicationFailureCount;
    }

    public long getUnchangedComputationElapsedMillis() {
        return this.unchangedComputationElapsedMillis;
    }

    public long getUnchangedNotificationElapsedMillis() {
        return this.unchangedNotificationElapsedMillis;
    }

    public long getSuccessfulComputationElapsedMillis() {
        return this.successfulComputationElapsedMillis;
    }

    public long getSuccessfulPublicationElapsedMillis() {
        return this.successfulPublicationElapsedMillis;
    }

    public long getSuccessfulContextConstructionElapsedMillis() {
        return this.successfulContextConstructionElapsedMillis;
    }

    public long getSuccessfulCommitElapsedMillis() {
        return this.successfulCommitElapsedMillis;
    }

    public long getSuccessfulCompletionElapsedMillis() {
        return this.successfulCompletionElapsedMillis;
    }

    public long getSuccessfulMasterApplyElapsedMillis() {
        return this.successfulMasterApplyElapsedMillis;
    }

    public long getSuccessfulNotificationElapsedMillis() {
        return this.successfulNotificationElapsedMillis;
    }

    public long getFailedComputationElapsedMillis() {
        return this.failedComputationElapsedMillis;
    }

    public long getFailedPublicationElapsedMillis() {
        return this.failedPublicationElapsedMillis;
    }

    public long getFailedContextConstructionElapsedMillis() {
        return this.failedContextConstructionElapsedMillis;
    }

    public long getFailedCommitElapsedMillis() {
        return this.failedCommitElapsedMillis;
    }

    public long getFailedCompletionElapsedMillis() {
        return this.failedCompletionElapsedMillis;
    }

    public long getFailedMasterApplyElapsedMillis() {
        return this.failedMasterApplyElapsedMillis;
    }

    public long getFailedNotificationElapsedMillis() {
        return this.failedNotificationElapsedMillis;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("cluster_state_update");
        builder.startObject("unchanged");
        builder.field("count", this.unchangedTaskCount);
        ClusterStateUpdateStats.msField(builder, "computation", this.unchangedComputationElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "notification", this.unchangedNotificationElapsedMillis);
        builder.endObject();
        builder.startObject("success");
        builder.field("count", this.publicationSuccessCount);
        ClusterStateUpdateStats.msField(builder, "computation", this.successfulComputationElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "publication", this.successfulPublicationElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "context_construction", this.successfulContextConstructionElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "commit", this.successfulCommitElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "completion", this.successfulCompletionElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "master_apply", this.successfulMasterApplyElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "notification", this.successfulNotificationElapsedMillis);
        builder.endObject();
        builder.startObject("failure");
        builder.field("count", this.publicationFailureCount);
        ClusterStateUpdateStats.msField(builder, "computation", this.failedComputationElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "publication", this.failedPublicationElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "context_construction", this.failedContextConstructionElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "commit", this.failedCommitElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "completion", this.failedCompletionElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "master_apply", this.failedMasterApplyElapsedMillis);
        ClusterStateUpdateStats.msField(builder, "notification", this.failedNotificationElapsedMillis);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static void msField(XContentBuilder builder, String name, long millis) throws IOException {
        builder.humanReadableField(name + "_time_millis", name + "_time", TimeValue.timeValueMillis(millis));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterStateUpdateStats that = (ClusterStateUpdateStats)o;
        return this.unchangedTaskCount == that.unchangedTaskCount && this.publicationSuccessCount == that.publicationSuccessCount && this.publicationFailureCount == that.publicationFailureCount && this.unchangedComputationElapsedMillis == that.unchangedComputationElapsedMillis && this.unchangedNotificationElapsedMillis == that.unchangedNotificationElapsedMillis && this.successfulComputationElapsedMillis == that.successfulComputationElapsedMillis && this.successfulPublicationElapsedMillis == that.successfulPublicationElapsedMillis && this.successfulContextConstructionElapsedMillis == that.successfulContextConstructionElapsedMillis && this.successfulCommitElapsedMillis == that.successfulCommitElapsedMillis && this.successfulCompletionElapsedMillis == that.successfulCompletionElapsedMillis && this.successfulMasterApplyElapsedMillis == that.successfulMasterApplyElapsedMillis && this.successfulNotificationElapsedMillis == that.successfulNotificationElapsedMillis && this.failedComputationElapsedMillis == that.failedComputationElapsedMillis && this.failedPublicationElapsedMillis == that.failedPublicationElapsedMillis && this.failedContextConstructionElapsedMillis == that.failedContextConstructionElapsedMillis && this.failedCommitElapsedMillis == that.failedCommitElapsedMillis && this.failedCompletionElapsedMillis == that.failedCompletionElapsedMillis && this.failedMasterApplyElapsedMillis == that.failedMasterApplyElapsedMillis && this.failedNotificationElapsedMillis == that.failedNotificationElapsedMillis;
    }

    public int hashCode() {
        return Objects.hash(this.unchangedTaskCount, this.publicationSuccessCount, this.publicationFailureCount, this.unchangedComputationElapsedMillis, this.unchangedNotificationElapsedMillis, this.successfulComputationElapsedMillis, this.successfulPublicationElapsedMillis, this.successfulContextConstructionElapsedMillis, this.successfulCommitElapsedMillis, this.successfulCompletionElapsedMillis, this.successfulMasterApplyElapsedMillis, this.successfulNotificationElapsedMillis, this.failedComputationElapsedMillis, this.failedPublicationElapsedMillis, this.failedContextConstructionElapsedMillis, this.failedCommitElapsedMillis, this.failedCompletionElapsedMillis, this.failedMasterApplyElapsedMillis, this.failedNotificationElapsedMillis);
    }
}

