/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.coordination.ClusterStateSerializationStats;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PublishClusterStateStats
implements Writeable,
ToXContentObject {
    private final long fullClusterStateReceivedCount;
    private final long incompatibleClusterStateDiffReceivedCount;
    private final long compatibleClusterStateDiffReceivedCount;
    private final ClusterStateSerializationStats clusterStateSerializationStats;

    public PublishClusterStateStats(long fullClusterStateReceivedCount, long incompatibleClusterStateDiffReceivedCount, long compatibleClusterStateDiffReceivedCount, ClusterStateSerializationStats clusterStateSerializationStats) {
        this.fullClusterStateReceivedCount = fullClusterStateReceivedCount;
        this.incompatibleClusterStateDiffReceivedCount = incompatibleClusterStateDiffReceivedCount;
        this.compatibleClusterStateDiffReceivedCount = compatibleClusterStateDiffReceivedCount;
        this.clusterStateSerializationStats = clusterStateSerializationStats;
    }

    public PublishClusterStateStats(StreamInput in) throws IOException {
        this.fullClusterStateReceivedCount = in.readVLong();
        this.incompatibleClusterStateDiffReceivedCount = in.readVLong();
        this.compatibleClusterStateDiffReceivedCount = in.readVLong();
        this.clusterStateSerializationStats = in.getVersion().onOrAfter(Version.V_7_16_0) ? new ClusterStateSerializationStats(in) : ClusterStateSerializationStats.EMPTY;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.fullClusterStateReceivedCount);
        out.writeVLong(this.incompatibleClusterStateDiffReceivedCount);
        out.writeVLong(this.compatibleClusterStateDiffReceivedCount);
        if (out.getVersion().onOrAfter(Version.V_7_16_0)) {
            this.clusterStateSerializationStats.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("serialized_cluster_states");
        this.clusterStateSerializationStats.toXContent(builder, params);
        builder.startObject("published_cluster_states");
        builder.field("full_states", this.fullClusterStateReceivedCount);
        builder.field("incompatible_diffs", this.incompatibleClusterStateDiffReceivedCount);
        builder.field("compatible_diffs", this.compatibleClusterStateDiffReceivedCount);
        builder.endObject();
        return builder;
    }

    public long getFullClusterStateReceivedCount() {
        return this.fullClusterStateReceivedCount;
    }

    public long getIncompatibleClusterStateDiffReceivedCount() {
        return this.incompatibleClusterStateDiffReceivedCount;
    }

    public long getCompatibleClusterStateDiffReceivedCount() {
        return this.compatibleClusterStateDiffReceivedCount;
    }

    public ClusterStateSerializationStats getClusterStateSerializationStats() {
        return this.clusterStateSerializationStats;
    }

    public String toString() {
        return "PublishClusterStateStats(full=" + this.fullClusterStateReceivedCount + ", incompatible=" + this.incompatibleClusterStateDiffReceivedCount + ", compatible=" + this.compatibleClusterStateDiffReceivedCount + ", serializationStats=" + Strings.toString(this.clusterStateSerializationStats) + ")";
    }
}

