/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine.frozen;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.ReadOnlyEngine;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.frozen.RewriteCachingDirectoryReader;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.indices.ESCacheHelper;

public final class FrozenEngine
extends ReadOnlyEngine {
    public static final Setting<Boolean> INDEX_FROZEN = Setting.boolSetting("index.frozen", false, Setting.Property.IndexScope, Setting.Property.PrivateIndex);
    private final SegmentsStats segmentsStats;
    private final DocsStats docsStats;
    private volatile ElasticsearchDirectoryReader lastOpenedReader;
    private final ElasticsearchDirectoryReader canMatchReader;
    private final Object cacheIdentity = new Object();
    private final Set<ESCacheHelper.ClosedListener> closedListeners = new CopyOnWriteArraySet<ESCacheHelper.ClosedListener>();

    public FrozenEngine(EngineConfig config, boolean requireCompleteHistory, boolean lazilyLoadSoftDeletes) {
        this(config, null, null, true, Function.identity(), requireCompleteHistory, lazilyLoadSoftDeletes);
    }

    public FrozenEngine(EngineConfig config, SeqNoStats seqNoStats, TranslogStats translogStats, boolean obtainLock, Function<DirectoryReader, DirectoryReader> readerWrapperFunction, boolean requireCompleteHistory, boolean lazilyLoadSoftDeletes) {
        super(config, seqNoStats, translogStats, obtainLock, readerWrapperFunction, requireCompleteHistory, lazilyLoadSoftDeletes);
        boolean success = false;
        Directory directory = this.store.directory();
        try (DirectoryReader reader = this.openDirectory(directory, config.getIndexSettings().isSoftDeleteEnabled());){
            this.segmentsStats = new SegmentsStats();
            for (LeafReaderContext ctx : reader.getContext().leaves()) {
                SegmentReader segmentReader = Lucene.segmentReader(ctx.reader());
                this.fillSegmentStats(segmentReader, true, this.segmentsStats);
            }
            this.docsStats = this.docsStats(reader);
            this.canMatchReader = ElasticsearchDirectoryReader.wrap(new RewriteCachingDirectoryReader(directory, reader.leaves(), null), config.getShardId());
            success = true;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (!success) {
                this.closeNoLock("failed on construction", new CountDownLatch(1));
            }
        }
    }

    @Override
    protected DirectoryReader open(final IndexCommit indexCommit) throws IOException {
        return new DirectoryReader(indexCommit.getDirectory(), new LeafReader[0], null){

            @Override
            protected DirectoryReader doOpenIfChanged() {
                return null;
            }

            @Override
            protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
                return null;
            }

            @Override
            protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
                return null;
            }

            @Override
            public long getVersion() {
                return 0L;
            }

            @Override
            public boolean isCurrent() {
                return true;
            }

            @Override
            public IndexCommit getIndexCommit() {
                return indexCommit;
            }

            @Override
            protected void doClose() {
            }

            @Override
            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
    }

    @SuppressForbidden(reason="we manage references explicitly here")
    private synchronized void onReaderClosed(IndexReader.CacheKey key) {
        if (this.lastOpenedReader != null && key == this.lastOpenedReader.getReaderCacheHelper().getKey()) {
            assert (this.lastOpenedReader.getRefCount() == 0);
            this.lastOpenedReader = null;
        }
    }

    @SuppressForbidden(reason="we manage references explicitly here")
    private synchronized void closeReader(IndexReader reader) throws IOException {
        reader.decRef();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ElasticsearchDirectoryReader getOrOpenReader() throws IOException {
        ElasticsearchDirectoryReader reader = null;
        boolean success = false;
        try {
            reader = this.getReader();
            if (reader == null) {
                for (ReferenceManager.RefreshListener listeners : this.config().getInternalRefreshListener()) {
                    listeners.beforeRefresh();
                }
                DirectoryReader dirReader = this.openDirectory(this.store.directory(), this.engineConfig.getIndexSettings().isSoftDeleteEnabled());
                reader = this.lastOpenedReader = this.wrapReader(dirReader, Function.identity(), new ESCacheHelper(){

                    @Override
                    public Object getKey() {
                        return FrozenEngine.this.cacheIdentity;
                    }

                    @Override
                    public void addClosedListener(ESCacheHelper.ClosedListener listener) {
                        FrozenEngine.this.closedListeners.add(Objects.requireNonNull(listener));
                    }
                });
                this.processReader(reader);
                reader.getReaderCacheHelper().addClosedListener(this::onReaderClosed);
                for (ReferenceManager.RefreshListener listeners : this.config().getInternalRefreshListener()) {
                    listeners.afterRefresh(true);
                }
            }
            success = true;
            ElasticsearchDirectoryReader elasticsearchDirectoryReader = reader;
            return elasticsearchDirectoryReader;
        }
        finally {
            if (!success) {
                IOUtils.close((Closeable)reader);
            }
        }
    }

    @SuppressForbidden(reason="we manage references explicitly here")
    private ElasticsearchDirectoryReader getReader() {
        ElasticsearchDirectoryReader readerRef = this.lastOpenedReader;
        if (readerRef != null && readerRef.tryIncRef()) {
            return readerRef;
        }
        return null;
    }

    @Override
    public Engine.SearcherSupplier acquireSearcherSupplier(Function<Engine.Searcher, Engine.Searcher> wrapper, final Engine.SearcherScope scope) throws EngineException {
        final Store store = this.store;
        store.incRef();
        return new Engine.SearcherSupplier(wrapper){

            @Override
            @SuppressForbidden(reason="we manage references explicitly here")
            public Engine.Searcher acquireSearcherInternal(String source) {
                try {
                    return FrozenEngine.this.openSearcher(source, scope);
                }
                catch (IOException exc) {
                    throw new UncheckedIOException(exc);
                }
            }

            @Override
            protected void doClose() {
                store.decRef();
            }

            @Override
            public String getSearcherId() {
                return FrozenEngine.this.getCommitId();
            }
        };
    }

    @SuppressForbidden(reason="we manage references explicitly here")
    private Engine.Searcher openSearcher(String source, Engine.SearcherScope scope) throws IOException {
        ElasticsearchDirectoryReader reader;
        boolean maybeOpenReader;
        switch (source) {
            case "load_seq_no": 
            case "load_version": {
                assert (false) : "this is a read-only engine";
            }
            case "doc_stats": {
                assert (false) : "doc stats are eagerly loaded";
            }
            case "refresh_needed": {
                assert (false) : "refresh_needed is always false";
            }
            case "segments": 
            case "segments_stats": 
            case "completion_stats": 
            case "field_range": 
            case "can_match": {
                maybeOpenReader = false;
                break;
            }
            default: {
                maybeOpenReader = true;
            }
        }
        ElasticsearchDirectoryReader elasticsearchDirectoryReader = reader = maybeOpenReader ? this.getOrOpenReader() : this.getReader();
        if (reader == null) {
            if ("can_match".equals(source) || "field_range".equals(source)) {
                this.canMatchReader.incRef();
                return new Engine.Searcher(source, this.canMatchReader, this.engineConfig.getSimilarity(), this.engineConfig.getQueryCache(), this.engineConfig.getQueryCachingPolicy(), this.canMatchReader::decRef);
            }
            ReferenceManager<ElasticsearchDirectoryReader> manager = this.getReferenceManager(scope);
            ElasticsearchDirectoryReader acquire = manager.acquire();
            return new Engine.Searcher(source, acquire, this.engineConfig.getSimilarity(), this.engineConfig.getQueryCache(), this.engineConfig.getQueryCachingPolicy(), () -> manager.release(acquire));
        }
        return new Engine.Searcher(source, reader, this.engineConfig.getSimilarity(), this.engineConfig.getQueryCache(), this.engineConfig.getQueryCachingPolicy(), () -> this.closeReader(reader));
    }

    @Override
    public SegmentsStats segmentsStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        if (includeUnloadedSegments) {
            SegmentsStats stats = new SegmentsStats();
            stats.add(this.segmentsStats);
            if (!includeSegmentFileSizes) {
                stats.clearFiles();
            }
            return stats;
        }
        return super.segmentsStats(includeSegmentFileSizes, includeUnloadedSegments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNoLock(String reason, CountDownLatch closedLatch) {
        super.closeNoLock(reason, closedLatch);
        Set<ESCacheHelper.ClosedListener> set = this.closedListeners;
        synchronized (set) {
            IOUtils.closeWhileHandlingException(this.closedListeners.stream().map(t -> () -> t.onClose(this.cacheIdentity))::iterator);
            this.closedListeners.clear();
        }
    }

    @Override
    public DocsStats docStats() {
        return this.docsStats;
    }

    synchronized boolean isReaderOpen() {
        return this.lastOpenedReader != null;
    }
}

