/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationSupplier;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalConsumer;
import org.elasticsearch.search.aggregations.bucket.histogram.DateIntervalWrapper;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.LongBounds;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DateHistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<DateHistogramAggregationBuilder>
implements DateIntervalConsumer<DateHistogramAggregationBuilder> {
    public static final String NAME = "date_histogram";
    public static final ValuesSourceRegistry.RegistryKey<DateHistogramAggregationSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<DateHistogramAggregationSupplier>("date_histogram", DateHistogramAggregationSupplier.class);
    public static final Map<String, Rounding.DateTimeUnit> DATE_FIELD_UNITS;
    public static final ObjectParser<DateHistogramAggregationBuilder, String> PARSER;
    private DateIntervalWrapper dateHistogramInterval = new DateIntervalWrapper();
    private long offset = 0L;
    private LongBounds extendedBounds;
    private LongBounds hardBounds;
    private BucketOrder order = BucketOrder.key(true);
    private boolean keyed = false;
    private long minDocCount = 0L;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        DateHistogramAggregatorFactory.registerAggregators(builder);
    }

    public DateHistogramAggregationBuilder(String name) {
        super(name);
    }

    protected DateHistogramAggregationBuilder(DateHistogramAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.dateHistogramInterval = clone.dateHistogramInterval;
        this.offset = clone.offset;
        this.extendedBounds = clone.extendedBounds;
        this.hardBounds = clone.hardBounds;
        this.order = clone.order;
        this.keyed = clone.keyed;
        this.minDocCount = clone.minDocCount;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new DateHistogramAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public DateHistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.order = InternalOrder.Streams.readHistogramOrder(in, true);
        this.keyed = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.dateHistogramInterval = new DateIntervalWrapper(in);
        this.offset = in.readLong();
        this.extendedBounds = in.readOptionalWriteable(LongBounds::new);
        if (in.getVersion().onOrAfter(Version.V_7_10_0)) {
            this.hardBounds = in.readOptionalWriteable(LongBounds::new);
        }
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.DATE;
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeHistogramOrder(this.order, out, true);
        out.writeBoolean(this.keyed);
        out.writeVLong(this.minDocCount);
        this.dateHistogramInterval.writeTo(out);
        out.writeLong(this.offset);
        out.writeOptionalWriteable(this.extendedBounds);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeOptionalWriteable(this.hardBounds);
        }
    }

    @Override
    @Deprecated
    public long interval() {
        return this.dateHistogramInterval.interval();
    }

    @Override
    @Deprecated
    public DateHistogramAggregationBuilder interval(long interval) {
        this.dateHistogramInterval.interval(interval);
        return this;
    }

    @Override
    @Deprecated
    public DateHistogramInterval dateHistogramInterval() {
        return this.dateHistogramInterval.dateHistogramInterval();
    }

    @Override
    @Deprecated
    public DateHistogramAggregationBuilder dateHistogramInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.dateHistogramInterval(interval);
        return this;
    }

    @Override
    public DateHistogramAggregationBuilder calendarInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.calendarInterval(interval);
        return this;
    }

    @Override
    public DateHistogramAggregationBuilder fixedInterval(DateHistogramInterval interval) {
        this.dateHistogramInterval.fixedInterval(interval);
        return this;
    }

    public DateHistogramInterval getCalendarInterval() {
        if (this.dateHistogramInterval.getIntervalType().equals(DateIntervalWrapper.IntervalTypeEnum.CALENDAR)) {
            return this.dateHistogramInterval.getAsCalendarInterval();
        }
        return null;
    }

    public DateHistogramInterval getFixedInterval() {
        if (this.dateHistogramInterval.getIntervalType().equals(DateIntervalWrapper.IntervalTypeEnum.FIXED)) {
            return this.dateHistogramInterval.getAsFixedInterval();
        }
        return null;
    }

    public long offset() {
        return this.offset;
    }

    public DateHistogramAggregationBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public DateHistogramAggregationBuilder offset(String offset) {
        if (offset == null) {
            throw new IllegalArgumentException("[offset] must not be null: [" + this.name + "]");
        }
        return this.offset(DateHistogramAggregationBuilder.parseStringOffset(offset));
    }

    public static long parseStringOffset(String offset) {
        if (offset.charAt(0) == '-') {
            return -TimeValue.parseTimeValue(offset.substring(1), null, DateHistogramAggregationBuilder.class.getSimpleName() + ".parseOffset").millis();
        }
        int beginIndex = offset.charAt(0) == '+' ? 1 : 0;
        return TimeValue.parseTimeValue(offset.substring(beginIndex), null, DateHistogramAggregationBuilder.class.getSimpleName() + ".parseOffset").millis();
    }

    public LongBounds extendedBounds() {
        return this.extendedBounds;
    }

    public DateHistogramAggregationBuilder extendedBounds(LongBounds extendedBounds) {
        if (extendedBounds == null) {
            throw new IllegalArgumentException("[extendedBounds] must not be null: [" + this.name + "]");
        }
        this.extendedBounds = extendedBounds;
        return this;
    }

    public LongBounds hardBounds() {
        return this.hardBounds;
    }

    public DateHistogramAggregationBuilder hardBounds(LongBounds hardBounds) {
        if (hardBounds == null) {
            throw new IllegalArgumentException("[hardBounds] must not be null: [" + this.name + "]");
        }
        this.hardBounds = hardBounds;
        return this;
    }

    public BucketOrder order() {
        return this.order;
    }

    public DateHistogramAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order instanceof InternalOrder.CompoundOrder || InternalOrder.isKeyOrder(order) ? order : BucketOrder.compound(order);
        return this;
    }

    public DateHistogramAggregationBuilder order(List<BucketOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order(orders.size() > 1 ? BucketOrder.compound(orders) : orders.get(0));
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public DateHistogramAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    public DateHistogramAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.minDocCount = minDocCount;
        return this;
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.MANY;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.dateHistogramInterval.toXContent(builder, params);
        builder.field(Histogram.OFFSET_FIELD.getPreferredName(), this.offset);
        if (this.order != null) {
            builder.field(Histogram.ORDER_FIELD.getPreferredName());
            this.order.toXContent(builder, params);
        }
        builder.field(Histogram.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(Histogram.MIN_DOC_COUNT_FIELD.getPreferredName(), this.minDocCount);
        if (this.extendedBounds != null) {
            builder.startObject(Histogram.EXTENDED_BOUNDS_FIELD.getPreferredName());
            this.extendedBounds.toXContent(builder, params);
            builder.endObject();
        }
        if (this.hardBounds != null) {
            builder.startObject(Histogram.HARD_BOUNDS_FIELD.getPreferredName());
            this.hardBounds.toXContent(builder, params);
            builder.endObject();
        }
        return builder;
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    @Override
    protected ValuesSourceAggregatorFactory innerBuild(AggregationContext context, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        DateHistogramAggregationSupplier aggregatorSupplier = context.getValuesSourceRegistry().getAggregator(REGISTRY_KEY, config);
        ZoneId tz = this.timeZone();
        Rounding rounding = this.dateHistogramInterval.createRounding(tz, this.offset);
        LongBounds roundedBounds = null;
        if (this.extendedBounds != null) {
            roundedBounds = this.extendedBounds.parseAndValidate(this.name, "extended_bounds", context::nowInMillis, config.format()).round(rounding);
        }
        LongBounds roundedHardBounds = null;
        if (this.hardBounds != null) {
            roundedHardBounds = this.hardBounds.parseAndValidate(this.name, "hard_bounds", context::nowInMillis, config.format()).round(rounding);
        }
        if (roundedBounds != null && roundedHardBounds != null) {
            if (roundedBounds.getMax() != null && roundedHardBounds.getMax() != null && roundedBounds.getMax() > roundedHardBounds.getMax()) {
                throw new IllegalArgumentException("Extended bounds have to be inside hard bounds, hard bounds: [" + this.hardBounds + "], extended bounds: [" + this.extendedBounds + "]");
            }
            if (roundedBounds.getMin() != null && roundedHardBounds.getMin() != null && roundedBounds.getMin() < roundedHardBounds.getMin()) {
                throw new IllegalArgumentException("Extended bounds have to be inside hard bounds, hard bounds: [" + this.hardBounds + "], extended bounds: [" + this.extendedBounds + "]");
            }
        }
        return new DateHistogramAggregatorFactory(this.name, config, this.order, this.keyed, this.minDocCount, rounding, roundedBounds, roundedHardBounds, context, parent, subFactoriesBuilder, this.metadata, aggregatorSupplier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.order, this.keyed, this.minDocCount, this.dateHistogramInterval, this.minDocCount, this.extendedBounds, this.hardBounds);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DateHistogramAggregationBuilder other = (DateHistogramAggregationBuilder)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.dateHistogramInterval, other.dateHistogramInterval) && Objects.equals(this.offset, other.offset) && Objects.equals(this.extendedBounds, other.extendedBounds) && Objects.equals(this.hardBounds, other.hardBounds);
    }

    static {
        HashMap<String, Rounding.DateTimeUnit> dateFieldUnits = new HashMap<String, Rounding.DateTimeUnit>();
        dateFieldUnits.put("year", Rounding.DateTimeUnit.YEAR_OF_CENTURY);
        dateFieldUnits.put("1y", Rounding.DateTimeUnit.YEAR_OF_CENTURY);
        dateFieldUnits.put("quarter", Rounding.DateTimeUnit.QUARTER_OF_YEAR);
        dateFieldUnits.put("1q", Rounding.DateTimeUnit.QUARTER_OF_YEAR);
        dateFieldUnits.put("month", Rounding.DateTimeUnit.MONTH_OF_YEAR);
        dateFieldUnits.put("1M", Rounding.DateTimeUnit.MONTH_OF_YEAR);
        dateFieldUnits.put("week", Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR);
        dateFieldUnits.put("1w", Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR);
        dateFieldUnits.put("day", Rounding.DateTimeUnit.DAY_OF_MONTH);
        dateFieldUnits.put("1d", Rounding.DateTimeUnit.DAY_OF_MONTH);
        dateFieldUnits.put("hour", Rounding.DateTimeUnit.HOUR_OF_DAY);
        dateFieldUnits.put("1h", Rounding.DateTimeUnit.HOUR_OF_DAY);
        dateFieldUnits.put("minute", Rounding.DateTimeUnit.MINUTES_OF_HOUR);
        dateFieldUnits.put("1m", Rounding.DateTimeUnit.MINUTES_OF_HOUR);
        dateFieldUnits.put("second", Rounding.DateTimeUnit.SECOND_OF_MINUTE);
        dateFieldUnits.put("1s", Rounding.DateTimeUnit.SECOND_OF_MINUTE);
        DATE_FIELD_UNITS = Collections.unmodifiableMap(dateFieldUnits);
        PARSER = ObjectParser.fromBuilder(NAME, DateHistogramAggregationBuilder::new);
        ValuesSourceAggregationBuilder.declareFields(PARSER, true, true, true);
        DateIntervalWrapper.declareIntervalFields(PARSER);
        PARSER.declareField(DateHistogramAggregationBuilder::offset, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return p.longValue();
            }
            return DateHistogramAggregationBuilder.parseStringOffset(p.text());
        }, Histogram.OFFSET_FIELD, ObjectParser.ValueType.LONG);
        PARSER.declareBoolean(DateHistogramAggregationBuilder::keyed, Histogram.KEYED_FIELD);
        PARSER.declareLong(DateHistogramAggregationBuilder::minDocCount, Histogram.MIN_DOC_COUNT_FIELD);
        PARSER.declareField(DateHistogramAggregationBuilder::extendedBounds, parser -> LongBounds.PARSER.apply((XContentParser)parser, (Void)null), Histogram.EXTENDED_BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(DateHistogramAggregationBuilder::hardBounds, parser -> LongBounds.PARSER.apply((XContentParser)parser, (Void)null), Histogram.HARD_BOUNDS_FIELD, ObjectParser.ValueType.OBJECT);
        PARSER.declareObjectArray(DateHistogramAggregationBuilder::order, (p, c) -> InternalOrder.Parser.parseOrderParam(p), Histogram.ORDER_FIELD);
    }
}

