/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleOriginationDateParser;
import org.elasticsearch.xpack.core.ilm.InitializePolicyException;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.Step;

public final class InitializePolicyContextStep
extends ClusterStateActionStep {
    public static final String INITIALIZATION_PHASE = "new";
    public static final Step.StepKey KEY = new Step.StepKey("new", "init", "init");
    private static final Logger logger = LogManager.getLogger(InitializePolicyContextStep.class);

    InitializePolicyContextStep(Step.StepKey key, Step.StepKey nextStepKey) {
        super(key, nextStepKey);
    }

    @Override
    public ClusterState performAction(Index index, ClusterState clusterState) {
        LifecycleExecutionState lifecycleState;
        IndexMetadata indexMetadata = clusterState.getMetadata().index(index);
        if (indexMetadata == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return clusterState;
        }
        IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexMetadata);
        try {
            lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
            if (lifecycleState.getLifecycleDate() != null) {
                return clusterState;
            }
            if (IndexLifecycleOriginationDateParser.shouldParseIndexName(indexMetadata.getSettings())) {
                long parsedOriginationDate = IndexLifecycleOriginationDateParser.parseIndexNameAndExtractDate(index.getName());
                indexMetadataBuilder.settingsVersion(indexMetadata.getSettingsVersion() + 1L).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.lifecycle.origination_date", parsedOriginationDate).build());
            }
        }
        catch (Exception e) {
            String policy = indexMetadata.getSettings().get("index.lifecycle.name");
            throw new InitializePolicyException(policy, index.getName(), e);
        }
        ClusterState.Builder newClusterStateBuilder = ClusterState.builder(clusterState);
        LifecycleExecutionState.Builder newCustomData = LifecycleExecutionState.builder(lifecycleState);
        newCustomData.setIndexCreationDate(indexMetadata.getCreationDate());
        indexMetadataBuilder.putCustom("ilm", newCustomData.build().asMap());
        newClusterStateBuilder.metadata(Metadata.builder(clusterState.getMetadata()).put(indexMetadataBuilder).build(false));
        return newClusterStateBuilder.build();
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

