/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TopClassEntry
implements Writeable,
ToXContentObject {
    public static final ParseField CLASS_NAME = new ParseField("class_name", new String[0]);
    public static final ParseField CLASS_PROBABILITY = new ParseField("class_probability", new String[0]);
    public static final ParseField CLASS_SCORE = new ParseField("class_score", new String[0]);
    public static final String NAME = "top_class";
    private static final ConstructingObjectParser<TopClassEntry, Void> PARSER = new ConstructingObjectParser("top_class", a -> new TopClassEntry(a[0], (Double)a[1], (Double)a[2]));
    private final Object classification;
    private final double probability;
    private final double score;

    public static TopClassEntry fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public TopClassEntry(Object classification, double probability, double score) {
        this.classification = ExceptionsHelper.requireNonNull(classification, CLASS_NAME);
        this.probability = probability;
        this.score = score;
    }

    public TopClassEntry(StreamInput in) throws IOException {
        this.classification = in.getVersion().onOrAfter(Version.V_7_8_0) ? in.readGenericValue() : in.readString();
        this.probability = in.readDouble();
        this.score = in.readDouble();
    }

    public Object getClassification() {
        return this.classification;
    }

    public double getProbability() {
        return this.probability;
    }

    public double getScore() {
        return this.score;
    }

    public Map<String, Object> asValueMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(3, 1.0f);
        map.put(CLASS_NAME.getPreferredName(), this.classification);
        map.put(CLASS_PROBABILITY.getPreferredName(), this.probability);
        map.put(CLASS_SCORE.getPreferredName(), this.score);
        return map;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CLASS_NAME.getPreferredName(), this.classification);
        builder.field(CLASS_PROBABILITY.getPreferredName(), this.probability);
        builder.field(CLASS_SCORE.getPreferredName(), this.score);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeGenericValue(this.classification);
        } else {
            out.writeString(this.classification.toString());
        }
        out.writeDouble(this.probability);
        out.writeDouble(this.score);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TopClassEntry that = (TopClassEntry)object;
        return Objects.equals(this.classification, that.classification) && this.probability == that.probability && this.score == that.score;
    }

    public int hashCode() {
        return Objects.hash(this.classification, this.probability, this.score);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, n) -> {
            Object o;
            XContentParser.Token token = p.currentToken();
            if (token == XContentParser.Token.VALUE_STRING) {
                o = p.text();
            } else if (token == XContentParser.Token.VALUE_BOOLEAN) {
                o = p.booleanValue();
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                o = p.doubleValue();
            } else {
                throw new XContentParseException(p.getTokenLocation(), "[top_class] failed to parse field [" + CLASS_NAME + "] value [" + (Object)((Object)token) + "] is not a string, boolean or number");
            }
            return o;
        }, CLASS_NAME, ObjectParser.ValueType.VALUE);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), CLASS_PROBABILITY);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), CLASS_SCORE);
    }
}

