/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms.pivot;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.pivot.DateHistogramGroupSource;
import org.elasticsearch.xpack.core.transform.transforms.pivot.GeoTileGroupSource;
import org.elasticsearch.xpack.core.transform.transforms.pivot.HistogramGroupSource;
import org.elasticsearch.xpack.core.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.xpack.core.transform.transforms.pivot.TermsGroupSource;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;

public class GroupConfig
implements Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(GroupConfig.class);
    private final Map<String, Object> source;
    private final Map<String, SingleGroupSource> groups;

    public GroupConfig(Map<String, Object> source, Map<String, SingleGroupSource> groups) {
        this.source = ExceptionsHelper.requireNonNull(source, TransformField.GROUP_BY.getPreferredName());
        this.groups = groups;
    }

    public GroupConfig(StreamInput in) throws IOException {
        this.source = in.readMap();
        this.groups = in.readOrderedMap(StreamInput::readString, stream -> {
            SingleGroupSource.Type groupType = SingleGroupSource.Type.fromId(stream.readByte());
            switch (groupType) {
                case TERMS: {
                    return new TermsGroupSource(stream);
                }
                case HISTOGRAM: {
                    return new HistogramGroupSource(stream);
                }
                case DATE_HISTOGRAM: {
                    return new DateHistogramGroupSource(stream);
                }
                case GEOTILE_GRID: {
                    return new GeoTileGroupSource(stream);
                }
            }
            throw new IOException("Unknown group type");
        });
    }

    public Map<String, SingleGroupSource> getGroups() {
        return this.groups;
    }

    public Collection<String> getUsedNames() {
        return this.groups != null ? this.groups.keySet() : Collections.emptySet();
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.groups == null) {
            validationException = ValidateActions.addValidationError("pivot.groups must not be null", validationException);
        } else {
            for (SingleGroupSource group : this.groups.values()) {
                validationException = group.validate(validationException);
            }
        }
        return validationException;
    }

    public void checkForDeprecations(String id, NamedXContentRegistry namedXContentRegistry, Consumer<DeprecationIssue> onDeprecation) {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.source);
        out.writeMap(this.groups, StreamOutput::writeString, (stream, value) -> {
            stream.writeByte(value.getType().getId());
            value.writeTo(stream);
        });
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.map(this.source);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GroupConfig that = (GroupConfig)other;
        return Objects.equals(this.source, that.source) && Objects.equals(this.groups, that.groups);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.groups);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GroupConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        NamedXContentRegistry registry = parser.getXContentRegistry();
        Map<String, Object> source = parser.mapOrdered();
        Map<String, SingleGroupSource> groups = null;
        if (source.isEmpty()) {
            if (!lenient) throw new IllegalArgumentException("Pivot transform configuration must specify at least 1 group_by");
            logger.warn("Pivot transform configuration must specify at least 1 group_by");
            return new GroupConfig(source, groups);
        }
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);
             XContentParser sourceParser = XContentType.JSON.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, BytesReference.bytes(xContentBuilder).streamInput());){
            groups = GroupConfig.parseGroupConfig(sourceParser, lenient);
            return new GroupConfig(source, groups);
        }
        catch (Exception e) {
            if (!lenient) throw e;
            logger.warn("Failed to parse group_by for pivot transform", (Throwable)e);
            return new GroupConfig(source, groups);
        }
    }

    private static Map<String, SingleGroupSource> parseGroupConfig(XContentParser parser, boolean lenient) throws IOException {
        XContentParser.Token token;
        Matcher validAggMatcher = AggregatorFactories.VALID_AGG_NAME.matcher("");
        LinkedHashMap<String, SingleGroupSource> groups = new LinkedHashMap<String, SingleGroupSource>();
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && (token = parser.nextToken()) != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Failed to parse object: Expected START_OBJECT but was: " + (Object)((Object)token), new Object[0]);
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            SingleGroupSource groupSource;
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            String destinationFieldName = parser.currentName();
            if (!validAggMatcher.reset(destinationFieldName).matches()) {
                throw new ParsingException(parser.getTokenLocation(), "Invalid group name [" + destinationFieldName + "]. Group names can contain any character except '[', ']', and '>'", new Object[0]);
            }
            token = parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            token = parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
            SingleGroupSource.Type groupType = SingleGroupSource.Type.valueOf(parser.currentName().toUpperCase(Locale.ROOT));
            token = parser.nextToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            switch (groupType) {
                case TERMS: {
                    groupSource = TermsGroupSource.fromXContent(parser, lenient);
                    break;
                }
                case HISTOGRAM: {
                    groupSource = HistogramGroupSource.fromXContent(parser, lenient);
                    break;
                }
                case DATE_HISTOGRAM: {
                    groupSource = DateHistogramGroupSource.fromXContent(parser, lenient);
                    break;
                }
                case GEOTILE_GRID: {
                    groupSource = GeoTileGroupSource.fromXContent(parser, lenient);
                    break;
                }
                default: {
                    throw new ParsingException(parser.getTokenLocation(), "invalid grouping type: " + (Object)((Object)groupType), new Object[0]);
                }
            }
            parser.nextToken();
            groups.put(destinationFieldName, groupSource);
        }
        return groups;
    }
}

