/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.encrypted;

import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Tuple;

final class SingleUseKey {
    private static final Logger logger = LogManager.getLogger(SingleUseKey.class);
    static final int MIN_NONCE = Integer.MIN_VALUE;
    static final int MAX_NONCE = Integer.MAX_VALUE;
    private static final int MAX_ATTEMPTS = 9;
    private static final SingleUseKey EXPIRED_KEY = new SingleUseKey(null, null, Integer.MAX_VALUE);
    private final BytesReference keyId;
    private final SecretKey key;
    private final int nonce;

    SingleUseKey(BytesReference KeyId, SecretKey Key2, int nonce) {
        this.keyId = KeyId;
        this.key = Key2;
        this.nonce = nonce;
    }

    public BytesReference getKeyId() {
        return this.keyId;
    }

    public SecretKey getKey() {
        return this.key;
    }

    public int getNonce() {
        return this.nonce;
    }

    static <T extends Exception> CheckedSupplier<SingleUseKey, T> createSingleUseKeySupplier(CheckedSupplier<Tuple<BytesReference, SecretKey>, T> keyGenerator) {
        AtomicReference<SingleUseKey> keyCurrentlyInUse = new AtomicReference<SingleUseKey>(EXPIRED_KEY);
        return SingleUseKey.internalSingleUseKeySupplier(keyGenerator, keyCurrentlyInUse);
    }

    static <T extends Exception> CheckedSupplier<SingleUseKey, T> internalSingleUseKeySupplier(CheckedSupplier<Tuple<BytesReference, SecretKey>, T> keyGenerator, AtomicReference<SingleUseKey> keyCurrentlyInUse) {
        Object lock = new Object();
        return () -> {
            for (int attemptNo = 0; attemptNo < 9; ++attemptNo) {
                SingleUseKey nonceAndKey = (SingleUseKey)keyCurrentlyInUse.getAndUpdate(prev -> prev.nonce < Integer.MAX_VALUE ? new SingleUseKey(prev.keyId, prev.key, prev.nonce + 1) : EXPIRED_KEY);
                if (nonceAndKey.nonce < Integer.MAX_VALUE) {
                    logger.trace(() -> new ParameterizedMessage("Key with id [{}] reused with nonce [{}]", (Object)nonceAndKey.keyId, (Object)nonceAndKey.nonce));
                    return nonceAndKey;
                }
                logger.trace(() -> new ParameterizedMessage("Try to generate a new key to replace the key with id [{}]", (Object)nonceAndKey.keyId));
                Object object = lock;
                synchronized (object) {
                    if (((SingleUseKey)keyCurrentlyInUse.get()).nonce == Integer.MAX_VALUE) {
                        Tuple newKey = (Tuple)keyGenerator.get();
                        logger.debug(() -> new ParameterizedMessage("New key with id [{}] has been generated", newKey.v1()));
                        keyCurrentlyInUse.set(new SingleUseKey((BytesReference)newKey.v1(), (SecretKey)newKey.v2(), Integer.MIN_VALUE));
                    }
                    continue;
                }
            }
            throw new IllegalStateException("Failure to generate new key");
        };
    }
}

