/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.structurefinder;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.elasticsearch.xpack.core.textstructure.structurefinder.TextStructure;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinderFactory;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;
import org.elasticsearch.xpack.textstructure.structurefinder.TimeoutChecker;
import org.elasticsearch.xpack.textstructure.structurefinder.XmlTextStructureFinder;
import org.xml.sax.SAXException;

public class XmlTextStructureFinderFactory
implements TextStructureFinderFactory {
    private final XMLInputFactory xmlFactory = XMLInputFactory.newInstance();

    public XmlTextStructureFinderFactory() {
        this.xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        this.xmlFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        this.xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.xmlFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        this.xmlFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
    }

    @Override
    public boolean canFindFormat(TextStructure.Format format) {
        return format == null || format == TextStructure.Format.XML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean canCreateFromSample(List<String> explanation, String sample, double allowedFractionOfBadLines) {
        boolean mightBeAnotherDocument;
        int completeDocCount = 0;
        String commonRootElementName = null;
        String remainder = sample.trim();
        boolean bl = mightBeAnotherDocument = !remainder.isEmpty();
        block20: while (mightBeAnotherDocument) {
            try (StringReader reader = new StringReader(remainder);
                 XMLStreamReader xmlReader = this.xmlFactory.createXMLStreamReader(reader);){
                int nestingLevel = 0;
                while (mightBeAnotherDocument = xmlReader.hasNext()) {
                    switch (xmlReader.next()) {
                        case 1: {
                            if (nestingLevel++ != 0) break;
                            String rootElementName = xmlReader.getLocalName();
                            if (commonRootElementName == null) {
                                commonRootElementName = rootElementName;
                                break;
                            }
                            if (commonRootElementName.equals(rootElementName)) break;
                            explanation.add("Not XML because different documents have different root element names: [" + commonRootElementName + "] and [" + rootElementName + "]");
                            boolean bl2 = false;
                            return bl2;
                        }
                        case 2: {
                            if (--nestingLevel >= 0) break;
                            explanation.add("Not XML because an end element occurs before a start element");
                            boolean rootElementName = false;
                            return rootElementName;
                        }
                    }
                    if (nestingLevel != 0) continue;
                    ++completeDocCount;
                    Location location = xmlReader.getLocation();
                    int endPos = 0;
                    for (int wholeLines = location.getLineNumber() - 1; wholeLines > 0; --wholeLines) {
                        if ((endPos = remainder.indexOf(10, endPos) + 1) != 0) continue;
                        explanation.add("Not XML because XML parser location is inconsistent: line [" + location.getLineNumber() + "], column [" + location.getColumnNumber() + "] in [" + remainder + "]");
                        boolean bl3 = false;
                        return bl3;
                    }
                    mightBeAnotherDocument = !(remainder = remainder.substring(endPos += location.getColumnNumber() - 1).trim()).isEmpty();
                    continue block20;
                }
            }
            catch (IOException | XMLStreamException e) {
                explanation.add("Not XML because there was a parsing exception: [" + e.getMessage().replaceAll("\\s?\r?\n\\s?", " ") + "]");
                return false;
            }
        }
        if (completeDocCount == 0) {
            explanation.add("Not XML because sample didn't contain a complete document");
            return false;
        }
        explanation.add("Deciding sample is XML");
        return true;
    }

    @Override
    public TextStructureFinder createFromSample(List<String> explanation, String sample, String charsetName, Boolean hasByteOrderMarker, int lineMergeSizeLimit, TextStructureOverrides overrides, TimeoutChecker timeoutChecker) throws IOException, ParserConfigurationException, SAXException {
        return XmlTextStructureFinder.makeXmlTextStructureFinder(explanation, sample, charsetName, hasByteOrderMarker, overrides, timeoutChecker);
    }
}

