/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.unit.ByteSizeUnit;

public class SearchableSnapshotsUtils {
    static final Comparator<String> SEGMENT_FILENAME_COMPARATOR = Comparator.comparingLong(SegmentInfos::generationFromSegmentsFileName);

    public static IndexCommit emptyIndexCommit(Directory directory) {
        try {
            String oldestSegmentsFile = Arrays.stream(directory.listAll()).filter(s -> s.startsWith("segments_")).min(SEGMENT_FILENAME_COMPARATOR).orElseThrow(() -> new IOException("segments_N file not found"));
            SegmentInfos segmentInfos = new SegmentInfos(Version.LATEST.major);
            segmentInfos.updateGeneration(SegmentInfos.readCommit((Directory)directory, (String)oldestSegmentsFile));
            return Lucene.getIndexCommit((SegmentInfos)segmentInfos, (Directory)directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static int toIntBytes(long l) {
        return ByteSizeUnit.BYTES.toIntBytes(l);
    }
}

