/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.eql.util.StringUtils;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.BaseSurrogateFunction;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.Predicates;
import org.elasticsearch.xpack.ql.expression.predicate.regex.Like;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class Wildcard
extends BaseSurrogateFunction {
    private final Expression field;
    private final List<Expression> patterns;
    private final boolean caseInsensitive;

    public Wildcard(Source source, Expression field, List<Expression> patterns, boolean caseInsensitive) {
        super(source, CollectionUtils.combine(Collections.singletonList(field), patterns));
        this.field = field;
        this.patterns = patterns;
        this.caseInsensitive = caseInsensitive;
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Wildcard::new, (Object)this.field, this.patterns, (Object)this.caseInsensitive);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Wildcard(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()), this.caseInsensitive);
    }

    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    protected Expression.TypeResolution resolveType() {
        Expression p;
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution lastResolution = TypeResolutions.isStringAndExact((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (lastResolution.unresolved()) {
            return lastResolution;
        }
        int index = 1;
        Iterator<Expression> iterator = this.patterns.iterator();
        while (iterator.hasNext() && !(lastResolution = TypeResolutions.isFoldable((Expression)(p = iterator.next()), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)index))).unresolved() && !(lastResolution = TypeResolutions.isString((Expression)p, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)index))).unresolved()) {
            ++index;
        }
        return lastResolution;
    }

    public ScalarFunction makeSubstitute() {
        return (ScalarFunction)Predicates.combineOr(this.patterns.stream().map(e -> new Like(this.source(), this.field, StringUtils.toLikePattern(e.fold().toString()), this.caseInsensitive)).collect(Collectors.toList()));
    }
}

