/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.preallocate;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xpack.searchablesnapshots.preallocate.LinuxPreallocator;
import org.elasticsearch.xpack.searchablesnapshots.preallocate.MacOsPreallocator;
import org.elasticsearch.xpack.searchablesnapshots.preallocate.NoNativePreallocator;
import org.elasticsearch.xpack.searchablesnapshots.preallocate.Preallocator;

public class Preallocate {
    private static final Logger logger = LogManager.getLogger(Preallocate.class);

    public static void preallocate(Path cacheFile, long fileSize) throws IOException {
        if (Constants.LINUX) {
            Preallocate.preallocate(cacheFile, fileSize, new LinuxPreallocator());
        } else if (Constants.MAC_OS_X) {
            Preallocate.preallocate(cacheFile, fileSize, new MacOsPreallocator());
        } else {
            Preallocate.preallocate(cacheFile, fileSize, new NoNativePreallocator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressForbidden(reason="need access to fd on FileOutputStream")
    private static void preallocate(Path cacheFile, long fileSize, Preallocator prealloactor) throws IOException {
        boolean success = false;
        try {
            if (prealloactor.useNative()) {
                try (FileOutputStream fileChannel = new FileOutputStream(cacheFile.toFile());){
                    long currentSize = fileChannel.getChannel().size();
                    if (currentSize < fileSize) {
                        logger.info("pre-allocating cache file [{}] ({}) using native methods", (Object)cacheFile, (Object)new ByteSizeValue(fileSize));
                        Field field = AccessController.doPrivileged(new FileDescriptorFieldAction(fileChannel));
                        int errno = prealloactor.preallocate((Integer)field.get(fileChannel.getFD()), currentSize, fileSize - currentSize);
                        if (errno == 0) {
                            success = true;
                            logger.debug("pre-allocated cache file [{}] using native methods", (Object)cacheFile);
                        } else {
                            logger.warn("failed to pre-allocate cache file [{}] using native methods, errno: [{}], error: [{}]", (Object)cacheFile, (Object)errno, (Object)prealloactor.error(errno));
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Message)new ParameterizedMessage("failed to pre-allocate cache file [{}] using native methods", (Object)cacheFile), (Throwable)e);
                }
            }
            try (RandomAccessFile raf = new RandomAccessFile(cacheFile.toFile(), "rw");){
                if (raf.length() != fileSize) {
                    logger.info("pre-allocating cache file [{}] ({}) using setLength method", (Object)cacheFile, (Object)new ByteSizeValue(fileSize));
                    raf.setLength(fileSize);
                    success = true;
                    logger.debug("pre-allocated cache file [{}] using setLength method", (Object)cacheFile);
                }
            }
            catch (Exception e) {
                logger.warn((Message)new ParameterizedMessage("failed to pre-allocate cache file [{}] using setLength method", (Object)cacheFile), (Throwable)e);
                throw e;
            }
        }
        finally {
            if (!success) {
                Files.deleteIfExists(cacheFile);
            }
        }
    }

    @SuppressForbidden(reason="need access to fd on FileOutputStream")
    private static class FileDescriptorFieldAction
    implements PrivilegedExceptionAction<Field> {
        private final FileOutputStream fileOutputStream;

        private FileDescriptorFieldAction(FileOutputStream fileOutputStream) {
            this.fileOutputStream = fileOutputStream;
        }

        @Override
        public Field run() throws IOException, NoSuchFieldException {
            Field f = this.fileOutputStream.getFD().getClass().getDeclaredField("fd");
            f.setAccessible(true);
            return f;
        }
    }
}

