/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.tasks.list.ListTasksRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.features.ResetFeatureStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.AssociatedIndexDescriptor;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.PersistentTaskPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.FixedExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.action.SetResetModeActionRequest;
import org.elasticsearch.xpack.core.scheduler.SchedulerEngine;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.TransformNamedXContentProvider;
import org.elasticsearch.xpack.core.transform.action.DeleteTransformAction;
import org.elasticsearch.xpack.core.transform.action.GetTransformAction;
import org.elasticsearch.xpack.core.transform.action.GetTransformStatsAction;
import org.elasticsearch.xpack.core.transform.action.PreviewTransformAction;
import org.elasticsearch.xpack.core.transform.action.PutTransformAction;
import org.elasticsearch.xpack.core.transform.action.SetResetModeAction;
import org.elasticsearch.xpack.core.transform.action.StartTransformAction;
import org.elasticsearch.xpack.core.transform.action.StopTransformAction;
import org.elasticsearch.xpack.core.transform.action.UpdateTransformAction;
import org.elasticsearch.xpack.core.transform.action.UpgradeTransformsAction;
import org.elasticsearch.xpack.core.transform.action.ValidateTransformAction;
import org.elasticsearch.xpack.core.transform.action.compat.DeleteTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.GetTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.GetTransformStatsActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.PreviewTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.PutTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.StartTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.StopTransformActionDeprecated;
import org.elasticsearch.xpack.core.transform.action.compat.UpdateTransformActionDeprecated;
import org.elasticsearch.xpack.transform.TransformClusterStateListener;
import org.elasticsearch.xpack.transform.TransformFeatureSet;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.action.TransportDeleteTransformAction;
import org.elasticsearch.xpack.transform.action.TransportGetTransformAction;
import org.elasticsearch.xpack.transform.action.TransportGetTransformStatsAction;
import org.elasticsearch.xpack.transform.action.TransportPreviewTransformAction;
import org.elasticsearch.xpack.transform.action.TransportPutTransformAction;
import org.elasticsearch.xpack.transform.action.TransportSetTransformResetModeAction;
import org.elasticsearch.xpack.transform.action.TransportStartTransformAction;
import org.elasticsearch.xpack.transform.action.TransportStopTransformAction;
import org.elasticsearch.xpack.transform.action.TransportUpdateTransformAction;
import org.elasticsearch.xpack.transform.action.TransportUpgradeTransformsAction;
import org.elasticsearch.xpack.transform.action.TransportValidateTransformAction;
import org.elasticsearch.xpack.transform.action.compat.TransportDeleteTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportGetTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportGetTransformStatsActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportPreviewTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportPutTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportStartTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportStopTransformActionDeprecated;
import org.elasticsearch.xpack.transform.action.compat.TransportUpdateTransformActionDeprecated;
import org.elasticsearch.xpack.transform.checkpoint.TransformCheckpointService;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.IndexBasedTransformConfigManager;
import org.elasticsearch.xpack.transform.persistence.TransformInternalIndex;
import org.elasticsearch.xpack.transform.rest.action.RestCatTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestDeleteTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestGetTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestGetTransformStatsAction;
import org.elasticsearch.xpack.transform.rest.action.RestPreviewTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestPutTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestStartTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestStopTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestUpdateTransformAction;
import org.elasticsearch.xpack.transform.rest.action.RestUpgradeTransformsAction;
import org.elasticsearch.xpack.transform.rest.action.compat.RestDeleteTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestGetTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestGetTransformStatsActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestPreviewTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestPutTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestStartTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestStopTransformActionDeprecated;
import org.elasticsearch.xpack.transform.rest.action.compat.RestUpdateTransformActionDeprecated;
import org.elasticsearch.xpack.transform.transforms.TransformPersistentTasksExecutor;

public class Transform
extends Plugin
implements SystemIndexPlugin,
PersistentTaskPlugin {
    public static final String NAME = "transform";
    public static final String TASK_THREAD_POOL_NAME = "transform_indexing";
    private static final Logger logger = LogManager.getLogger(Transform.class);
    private final Settings settings;
    private final boolean transportClientMode;
    private final SetOnce<TransformServices> transformServices = new SetOnce();
    public static final int DEFAULT_FAILURE_RETRIES = 10;
    public static final Integer DEFAULT_INITIAL_MAX_PAGE_SEARCH_SIZE = 500;
    public static final TimeValue DEFAULT_TRANSFORM_FREQUENCY = TimeValue.timeValueMillis((long)60000L);
    public static final Setting<Integer> NUM_FAILURE_RETRIES_SETTING = Setting.intSetting((String)"xpack.transform.num_transform_failure_retries", (int)10, (int)0, (int)100, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    @Deprecated
    private static final String TRANSFORM_ENABLED_NODE_ATTR = "transform.node";
    private static final Setting<Boolean> TRANSFORM_ENABLED_NODE = Setting.boolSetting((String)"node.transform", settings -> Boolean.toString(DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.DATA_ROLE) || DataTier.isExplicitDataTier((Settings)settings)), (Setting.Property[])new Setting.Property[]{Setting.Property.Deprecated, Setting.Property.NodeScope});
    public static final DiscoveryNodeRole TRANSFORM_ROLE = new DiscoveryNodeRole("transform", "t"){

        public Setting<Boolean> legacySetting() {
            return TRANSFORM_ENABLED_NODE;
        }

        public boolean isEnabledByDefault(Settings settings) {
            return super.isEnabledByDefault(settings) && (DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.DATA_ROLE) || DataTier.isExplicitDataTier((Settings)settings));
        }
    };

    public Transform(Settings settings) {
        this.settings = settings;
        this.transportClientMode = XPackPlugin.transportClientMode((Settings)settings);
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        if (this.transportClientMode) {
            return modules;
        }
        modules.add(b -> XPackPlugin.bindFeatureSet((Binder)b, TransformFeatureSet.class));
        return modules;
    }

    protected XPackLicenseState getLicenseState() {
        return XPackPlugin.getSharedLicenseState();
    }

    public List<RestHandler> getRestHandlers(Settings unused, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new RestPutTransformAction(), new RestStartTransformAction(), new RestStopTransformAction(), new RestDeleteTransformAction(), new RestGetTransformAction(), new RestGetTransformStatsAction(), new RestPreviewTransformAction(), new RestUpdateTransformAction(), new RestCatTransformAction(), new RestUpgradeTransformsAction(), new RestPutTransformActionDeprecated(), new RestStartTransformActionDeprecated(), new RestStopTransformActionDeprecated(), new RestDeleteTransformActionDeprecated(), new RestGetTransformActionDeprecated(), new RestGetTransformStatsActionDeprecated(), new RestPreviewTransformActionDeprecated(), new RestUpdateTransformActionDeprecated()});
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)PutTransformAction.INSTANCE, TransportPutTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartTransformAction.INSTANCE, TransportStartTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopTransformAction.INSTANCE, TransportStopTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteTransformAction.INSTANCE, TransportDeleteTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTransformAction.INSTANCE, TransportGetTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTransformStatsAction.INSTANCE, TransportGetTransformStatsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PreviewTransformAction.INSTANCE, TransportPreviewTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateTransformAction.INSTANCE, TransportUpdateTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SetResetModeAction.INSTANCE, TransportSetTransformResetModeAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ValidateTransformAction.INSTANCE, TransportValidateTransformAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpgradeTransformsAction.INSTANCE, TransportUpgradeTransformsAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PutTransformActionDeprecated.INSTANCE, TransportPutTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StartTransformActionDeprecated.INSTANCE, TransportStartTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopTransformActionDeprecated.INSTANCE, TransportStopTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteTransformActionDeprecated.INSTANCE, TransportDeleteTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTransformActionDeprecated.INSTANCE, TransportGetTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetTransformStatsActionDeprecated.INSTANCE, TransportGetTransformStatsActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PreviewTransformActionDeprecated.INSTANCE, TransportPreviewTransformActionDeprecated.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateTransformActionDeprecated.INSTANCE, TransportUpdateTransformActionDeprecated.class, new Class[0]));
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settingsToUse) {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        FixedExecutorBuilder indexing = new FixedExecutorBuilder(settingsToUse, TASK_THREAD_POOL_NAME, 4, 4, "transform.task_thread_pool");
        return Collections.singletonList(indexing);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver expressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        IndexBasedTransformConfigManager configManager = new IndexBasedTransformConfigManager(clusterService, expressionResolver, client, xContentRegistry);
        TransformAuditor auditor = new TransformAuditor(client, clusterService.getNodeName(), clusterService);
        TransformCheckpointService checkpointService = new TransformCheckpointService(Clock.systemUTC(), this.settings, clusterService, configManager, auditor);
        SchedulerEngine scheduler = new SchedulerEngine(this.settings, Clock.systemUTC());
        this.transformServices.set((Object)new TransformServices(configManager, checkpointService, auditor, scheduler));
        return Arrays.asList(this.transformServices.get(), new TransformClusterStateListener(clusterService, client));
    }

    public List<PersistentTasksExecutor<?>> getPersistentTasksExecutor(ClusterService clusterService, ThreadPool threadPool, Client client, SettingsModule settingsModule, IndexNameExpressionResolver expressionResolver) {
        if (this.transportClientMode) {
            return Collections.emptyList();
        }
        assert (this.transformServices.get() != null);
        return Collections.singletonList(new TransformPersistentTasksExecutor(client, (TransformServices)this.transformServices.get(), threadPool, clusterService, settingsModule.getSettings(), expressionResolver));
    }

    public List<Setting<?>> getSettings() {
        return Collections.unmodifiableList(Arrays.asList(TRANSFORM_ENABLED_NODE, NUM_FAILURE_RETRIES_SETTING));
    }

    public Settings additionalSettings() {
        String transformEnabledNodeAttribute = "node.attr.transform.node";
        if (this.settings.get(transformEnabledNodeAttribute) != null) {
            throw new IllegalArgumentException("Directly setting transform node attributes is not permitted, please use the documented node settings instead");
        }
        Settings.Builder additionalSettings = Settings.builder();
        additionalSettings.put(transformEnabledNodeAttribute, DiscoveryNode.hasRole((Settings)this.settings, (DiscoveryNodeRole)TRANSFORM_ROLE));
        return additionalSettings.build();
    }

    public Set<DiscoveryNodeRole> getRoles() {
        return Collections.singleton(TRANSFORM_ROLE);
    }

    public void close() {
        if (this.transformServices.get() != null) {
            ((TransformServices)this.transformServices.get()).getSchedulerEngine().stop();
        }
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return new TransformNamedXContentProvider().getNamedXContentParsers();
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        try {
            return Collections.singletonList(TransformInternalIndex.getSystemIndexDescriptor());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Collection<AssociatedIndexDescriptor> getAssociatedIndexDescriptors() {
        return Collections.singletonList(new AssociatedIndexDescriptor(".transform-notifications-*", "Audit index"));
    }

    public void cleanUpFeature(ClusterService clusterService, Client unwrappedClient, ActionListener<ResetFeatureStateResponse.ResetFeatureStateStatus> finalListener) {
        OriginSettingClient client = new OriginSettingClient(unwrappedClient, NAME);
        ActionListener unsetResetModeListener = ActionListener.wrap(success -> client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.disabled((boolean)true), ActionListener.wrap(resetSuccess -> finalListener.onResponse(success), resetFailure -> {
            logger.error("failed to disable reset mode after otherwise successful transform reset", (Throwable)resetFailure);
            finalListener.onFailure((Exception)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Failed to set [reset_mode] to [false] after {0}. To allow transforms to run, please call the feature reset API again", (Object[])new Object[]{"a successful feature reset"}), RestStatus.INTERNAL_SERVER_ERROR, (Throwable)resetFailure, new Object[0]));
        })), failure -> client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.disabled((boolean)false), ActionListener.wrap(resetSuccess -> finalListener.onFailure(failure), resetFailure -> {
            logger.error(TransformMessages.getMessage((String)"Failed to set [reset_mode] to [false] after {0}. To allow transforms to run, please call the feature reset API again", (Object[])new Object[]{"a failed feature reset"}), (Throwable)resetFailure);
            ElasticsearchException ex = new ElasticsearchException(TransformMessages.getMessage((String)"Failed to set [reset_mode] to [false] after {0}. To allow transforms to run, please call the feature reset API again", (Object[])new Object[]{"a failed feature reset"}), new Object[0]);
            ex.addSuppressed((Throwable)resetFailure);
            failure.addSuppressed(ex);
            finalListener.onFailure(failure);
        })));
        ActionListener afterWaitingForTasks = ActionListener.wrap(listTasksResponse -> {
            listTasksResponse.rethrowFailures("Waiting for transform indexing tasks");
            super.cleanUpFeature(clusterService, (Client)client, unsetResetModeListener);
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener afterStoppingTransforms = ActionListener.wrap(stopTransformsResponse -> {
            if (stopTransformsResponse.isAcknowledged() && stopTransformsResponse.getTaskFailures().isEmpty() && stopTransformsResponse.getNodeFailures().isEmpty()) {
                ((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"data_frame/transforms"})).setWaitForCompletion(true).execute(ActionListener.wrap(listTransformTasks -> {
                    listTransformTasks.rethrowFailures("Waiting for transform tasks");
                    ((ListTasksRequestBuilder)client.admin().cluster().prepareListTasks(new String[0]).setActions(new String[]{"indices:data/write/bulk"})).setDetailed(true).setWaitForCompletion(true).setDescriptions(new String[]{"*.transform-*", "*.data-frame-*"}).execute(afterWaitingForTasks);
                }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0)));
            } else {
                String errMsg = "Failed to reset Transform: " + (stopTransformsResponse.isAcknowledged() ? "" : "not acknowledged ") + (stopTransformsResponse.getNodeFailures().isEmpty() ? "" : "node failures: " + stopTransformsResponse.getNodeFailures() + " ") + (stopTransformsResponse.getTaskFailures().isEmpty() ? "" : "task failures: " + stopTransformsResponse.getTaskFailures());
                unsetResetModeListener.onResponse((Object)ResetFeatureStateResponse.ResetFeatureStateStatus.failure((String)this.getFeatureName(), (Exception)((Object)new ElasticsearchException(errMsg, new Object[0]))));
            }
        }, arg_0 -> ((ActionListener)unsetResetModeListener).onFailure(arg_0));
        ActionListener afterResetModeSet = ActionListener.wrap(response -> {
            StopTransformAction.Request stopTransformsRequest = new StopTransformAction.Request("_all", true, true, null, true, false);
            client.execute((ActionType)StopTransformAction.INSTANCE, (ActionRequest)stopTransformsRequest, afterStoppingTransforms);
        }, arg_0 -> finalListener.onFailure(arg_0));
        client.execute((ActionType)SetResetModeAction.INSTANCE, (ActionRequest)SetResetModeActionRequest.enabled(), afterResetModeSet);
    }

    public String getFeatureName() {
        return NAME;
    }

    public String getFeatureDescription() {
        return "Manages configuration and state for transforms";
    }
}

