/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;

public class PivotExtractor
implements BucketExtractor {
    static final String NAME = "pv";
    private final BucketExtractor groupExtractor;
    private final BucketExtractor metricExtractor;
    private final Object value;

    public PivotExtractor(BucketExtractor groupExtractor, BucketExtractor metricExtractor, Object value) {
        this.groupExtractor = groupExtractor;
        this.metricExtractor = metricExtractor;
        this.value = value;
    }

    PivotExtractor(StreamInput in) throws IOException {
        this.groupExtractor = (BucketExtractor)in.readNamedWriteable(BucketExtractor.class);
        this.metricExtractor = (BucketExtractor)in.readNamedWriteable(BucketExtractor.class);
        this.value = in.readGenericValue();
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.groupExtractor);
        out.writeNamedWriteable((NamedWriteable)this.metricExtractor);
        out.writeGenericValue(this.value);
    }

    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        if (Objects.equals(this.value, this.groupExtractor.extract(bucket))) {
            return this.metricExtractor.extract(bucket);
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.groupExtractor, this.metricExtractor, this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PivotExtractor other = (PivotExtractor)obj;
        return Objects.equals(this.groupExtractor, other.groupExtractor) && Objects.equals(this.metricExtractor, other.metricExtractor) && Objects.equals(this.value, other.value);
    }
}

