/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeProcessor;

public class NamedDateTimeProcessor
extends BaseDateTimeProcessor {
    public static final String NAME = "ndt";
    private static final DateTimeFormatter DAY_NAME_FORMATTER = DateTimeFormatter.ofPattern("EEEE", Locale.ROOT);
    private static final DateTimeFormatter MONTH_NAME_FORMATTER = DateTimeFormatter.ofPattern("MMMM", Locale.ROOT);
    private final NameExtractor extractor;

    public NamedDateTimeProcessor(NameExtractor extractor, ZoneId zoneId) {
        super(zoneId);
        this.extractor = extractor;
    }

    public NamedDateTimeProcessor(StreamInput in) throws IOException {
        super(in);
        this.extractor = (NameExtractor)in.readEnum(NameExtractor.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.extractor);
    }

    public String getWriteableName() {
        return NAME;
    }

    NameExtractor extractor() {
        return this.extractor;
    }

    @Override
    public Object doProcess(ZonedDateTime dateTime) {
        return this.extractor.extract(dateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extractor, this.zoneId()});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        NamedDateTimeProcessor other = (NamedDateTimeProcessor)obj;
        return Objects.equals((Object)this.extractor, (Object)other.extractor) && Objects.equals(this.zoneId(), other.zoneId());
    }

    public String toString() {
        return this.extractor.toString();
    }

    public static enum NameExtractor {
        DAY_NAME(time -> time.format(DAY_NAME_FORMATTER)),
        MONTH_NAME(time -> time.format(MONTH_NAME_FORMATTER));

        private final Function<ZonedDateTime, String> apply;

        private NameExtractor(Function<ZonedDateTime, String> apply) {
            this.apply = apply;
        }

        public final String extract(ZonedDateTime dateTime) {
            return this.apply.apply(dateTime);
        }

        public final String extract(ZonedDateTime millis, String tzId) {
            return this.apply.apply(millis.withZoneSameInstant(ZoneId.of(tzId)));
        }
    }
}

