/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.util.CollectionUtils;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Case;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.IfConditional;
import org.elasticsearch.xpack.sql.type.SqlDataTypes;

public class Iif
extends Case
implements OptionalArgument {
    public Iif(Source source, Expression condition, Expression thenResult, Expression elseResult) {
        super(source, Arrays.asList(new Expression[]{new IfConditional(source, condition, thenResult), elseResult != null ? elseResult : Literal.NULL}));
    }

    Iif(Source source, List<Expression> expressions) {
        super(source, expressions);
    }

    protected NodeInfo<? extends Iif> info() {
        return NodeInfo.create((Node)this, Iif::new, (Object)CollectionUtils.combine(this.conditions(), (Object[])new Expression[]{this.elseResult()}));
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Iif(this.source(), newChildren);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (this.conditions().isEmpty()) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        Expression.TypeResolution conditionTypeResolution = TypeResolutions.isBoolean((Expression)this.conditions().get(0).condition(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (conditionTypeResolution.unresolved()) {
            return conditionTypeResolution;
        }
        DataType resultDataType = this.conditions().get(0).dataType();
        if (!SqlDataTypes.areCompatible(resultDataType, this.elseResult().dataType())) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"third argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{this.sourceText(), resultDataType.typeName(), Expressions.name((Expression)this.elseResult()), this.elseResult().dataType().typeName()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }
}

