/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardSnapshotInfo;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;

public class IndexSnapshotsService {
    private static final Comparator<Tuple<SnapshotId, RepositoryData.SnapshotDetails>> START_TIME_COMPARATOR = Comparator.comparingLong(pair -> ((RepositoryData.SnapshotDetails)pair.v2()).getStartTimeMillis()).thenComparing(Tuple::v1);
    private final RepositoriesService repositoriesService;

    public IndexSnapshotsService(RepositoriesService repositoriesService) {
        this.repositoriesService = repositoriesService;
    }

    public void getLatestSuccessfulSnapshotForShard(String repositoryName, ShardId shardId, ActionListener<Optional<ShardSnapshotInfo>> originalListener) {
        ActionListener<Optional<ShardSnapshotInfo>> listener = originalListener.delegateResponse((delegate, err) -> delegate.onFailure(new RepositoryException(repositoryName, "Unable to find the latest snapshot for shard [" + shardId + "]", (Throwable)err)));
        Repository repository = this.getRepository(repositoryName);
        if (repository == null) {
            listener.onFailure(new RepositoryMissingException(repositoryName));
            return;
        }
        String indexName = shardId.getIndexName();
        StepListener<RepositoryData> repositoryDataStepListener = new StepListener<RepositoryData>();
        StepListener snapshotInfoStepListener = new StepListener();
        repositoryDataStepListener.whenComplete(repositoryData -> {
            if (!repositoryData.hasIndex(indexName)) {
                listener.onResponse(Optional.empty());
                return;
            }
            IndexId indexId = repositoryData.resolveIndexId(indexName);
            List<SnapshotId> indexSnapshots = repositoryData.getSnapshots(indexId);
            Optional<SnapshotId> latestSnapshotId = indexSnapshots.stream().map(snapshotId -> Tuple.tuple((Object)snapshotId, (Object)repositoryData.getSnapshotDetails((SnapshotId)snapshotId))).filter(s -> ((RepositoryData.SnapshotDetails)s.v2()).getSnapshotState() != null && ((RepositoryData.SnapshotDetails)s.v2()).getSnapshotState() == SnapshotState.SUCCESS).filter(s -> ((RepositoryData.SnapshotDetails)s.v2()).getStartTimeMillis() != -1L && ((RepositoryData.SnapshotDetails)s.v2()).getEndTimeMillis() != -1L).max(START_TIME_COMPARATOR).map(Tuple::v1);
            if (!latestSnapshotId.isPresent()) {
                listener.onResponse(Optional.empty());
                return;
            }
            SnapshotId snapshotId2 = latestSnapshotId.get();
            repository.getSnapshotInfo(snapshotId2, snapshotInfoStepListener.map(snapshotInfo -> new FetchShardSnapshotContext(repository, (RepositoryData)repositoryData, indexId, shardId, (SnapshotInfo)snapshotInfo)));
        }, listener::onFailure);
        snapshotInfoStepListener.whenComplete(fetchSnapshotContext -> {
            assert (Thread.currentThread().getName().contains("[snapshot_meta]")) : "Expected current thread [" + Thread.currentThread() + "] to be a snapshot meta thread.";
            SnapshotInfo snapshotInfo = fetchSnapshotContext.getSnapshotInfo();
            if (snapshotInfo == null || snapshotInfo.state() != SnapshotState.SUCCESS) {
                listener.onResponse(Optional.empty());
                return;
            }
            BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots = ((FetchShardSnapshotContext)fetchSnapshotContext).getBlobStoreIndexShardSnapshots();
            String indexMetadataId = ((FetchShardSnapshotContext)fetchSnapshotContext).getIndexMetadataId();
            Optional<ShardSnapshotInfo> indexShardSnapshotInfo = blobStoreIndexShardSnapshots.snapshots().stream().filter(snapshotFiles -> snapshotFiles.snapshot().equals(snapshotInfo.snapshotId().getName())).findFirst().map(snapshotFiles -> ((FetchShardSnapshotContext)fetchSnapshotContext).createIndexShardSnapshotInfo(indexMetadataId, snapshotFiles));
            listener.onResponse(indexShardSnapshotInfo);
        }, listener::onFailure);
        repository.getRepositoryData(repositoryDataStepListener);
    }

    private Repository getRepository(String repositoryName) {
        Map<String, Repository> repositories = this.repositoriesService.getRepositories();
        return repositories.get(repositoryName);
    }

    private static class FetchShardSnapshotContext {
        private final Repository repository;
        private final RepositoryData repositoryData;
        private final IndexId indexId;
        private final ShardId shardId;
        private final SnapshotInfo snapshotInfo;

        FetchShardSnapshotContext(Repository repository, RepositoryData repositoryData, IndexId indexId, ShardId shardId, SnapshotInfo snapshotInfo) {
            this.repository = repository;
            this.repositoryData = repositoryData;
            this.indexId = indexId;
            this.shardId = shardId;
            this.snapshotInfo = snapshotInfo;
        }

        private String getIndexMetadataId() throws IOException {
            IndexMetaDataGenerations indexMetaDataGenerations = this.repositoryData.indexMetaDataGenerations();
            String indexMetadataIdentifier = indexMetaDataGenerations.snapshotIndexMetadataIdentifier(this.snapshotInfo.snapshotId(), this.indexId);
            if (indexMetadataIdentifier != null) {
                return indexMetadataIdentifier;
            }
            IndexMetadata indexMetadata = this.repository.getSnapshotIndexMetaData(this.repositoryData, this.snapshotInfo.snapshotId(), this.indexId);
            return IndexMetaDataGenerations.buildUniqueIdentifier(indexMetadata);
        }

        private BlobStoreIndexShardSnapshots getBlobStoreIndexShardSnapshots() throws IOException {
            BlobStoreRepository blobStoreRepository = (BlobStoreRepository)this.repository;
            ShardGeneration shardGen = this.repositoryData.shardGenerations().getShardGen(this.indexId, this.shardId.getId());
            return blobStoreRepository.getBlobStoreIndexShardSnapshots(this.indexId, this.shardId.getId(), shardGen);
        }

        private ShardSnapshotInfo createIndexShardSnapshotInfo(String indexMetadataId, SnapshotFiles snapshotFiles) {
            return new ShardSnapshotInfo(this.indexId, this.shardId, this.snapshotInfo.snapshot(), indexMetadataId, snapshotFiles.shardStateIdentifier(), this.snapshotInfo.startTime());
        }

        SnapshotInfo getSnapshotInfo() {
            return this.snapshotInfo;
        }
    }
}

