/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.ReleasableLock;

public class LockingAtomicCounter {
    private static final Logger logger = LogManager.getLogger(LockingAtomicCounter.class);
    private final AtomicLong counter = new AtomicLong();
    private final ReadWriteLock countingLock = new ReentrantReadWriteLock();
    private final ReleasableLock countingReadLock = new ReleasableLock(this.countingLock.readLock());
    private final ReleasableLock countingWriteLock = new ReleasableLock(this.countingLock.writeLock());

    public long get() {
        return this.counter.get();
    }

    public boolean compareAndRun(long count, Runnable runnable) {
        assert (count >= 0L) : "Count must be non-negative";
        try (ReleasableLock ignored = this.countingReadLock.acquire();){
            if (count == this.counter.get()) {
                logger.debug("Count matches [{}], executing runnable", (Object)count);
                runnable.run();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public void increment() {
        try (ReleasableLock ignored = this.countingWriteLock.acquire();){
            this.counter.incrementAndGet();
        }
    }
}

