/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.stats.FieldScriptStats;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class RuntimeFieldStats
implements Writeable,
ToXContentObject {
    private final String type;
    final FieldScriptStats fieldScriptStats;
    int count = 0;
    int indexCount = 0;
    final Set<String> scriptLangs;
    long scriptLessCount = 0L;
    long shadowedCount = 0L;

    public RuntimeFieldStats(String type) {
        this.type = Objects.requireNonNull(type);
        this.scriptLangs = new HashSet<String>();
        this.fieldScriptStats = new FieldScriptStats();
    }

    public RuntimeFieldStats(StreamInput in) throws IOException {
        this.type = in.readString();
        this.count = in.readInt();
        this.indexCount = in.readInt();
        this.scriptLangs = in.readSet(StreamInput::readString);
        this.scriptLessCount = in.readLong();
        this.shadowedCount = in.readLong();
        this.fieldScriptStats = new FieldScriptStats(in);
    }

    public String type() {
        return this.type;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeInt(this.count);
        out.writeInt(this.indexCount);
        out.writeCollection(this.scriptLangs, StreamOutput::writeString);
        out.writeLong(this.scriptLessCount);
        out.writeLong(this.shadowedCount);
        this.fieldScriptStats.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.type);
        builder.field("count", this.count);
        builder.field("index_count", this.indexCount);
        builder.field("scriptless_count", this.scriptLessCount);
        builder.field("shadowed_count", this.shadowedCount);
        builder.array("lang", this.scriptLangs.toArray(new String[0]));
        this.fieldScriptStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeFieldStats that = (RuntimeFieldStats)o;
        return this.count == that.count && this.indexCount == that.indexCount && this.scriptLessCount == that.scriptLessCount && this.shadowedCount == that.shadowedCount && this.fieldScriptStats.equals(that.fieldScriptStats) && this.type.equals(that.type) && this.scriptLangs.equals(that.scriptLangs);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.count, this.indexCount, this.scriptLangs, this.scriptLessCount, this.shadowedCount, this.fieldScriptStats);
    }
}

