/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.diskusage;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.admin.indices.diskusage.IndexDiskUsageStats;
import org.elasticsearch.action.support.broadcast.BroadcastShardResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

final class AnalyzeDiskUsageShardResponse
extends BroadcastShardResponse {
    final IndexDiskUsageStats stats;

    AnalyzeDiskUsageShardResponse(StreamInput in) throws IOException {
        super(in);
        this.stats = new IndexDiskUsageStats(in);
    }

    AnalyzeDiskUsageShardResponse(ShardId shardId, IndexDiskUsageStats stats) {
        super(shardId);
        this.stats = Objects.requireNonNull(stats, "stats must be non null");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.stats.writeTo(out);
    }
}

