/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterState
implements ToXContentFragment,
Diffable<ClusterState> {
    public static final ClusterState EMPTY_STATE = ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.getDefault(Settings.EMPTY)).build();
    private static final NamedDiffableValueSerializer<Custom> CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Custom>(Custom.class);
    public static final String UNKNOWN_UUID = "_na_";
    public static final long UNKNOWN_VERSION = -1L;
    private final long version;
    private final String stateUUID;
    private final RoutingTable routingTable;
    private final DiscoveryNodes nodes;
    private final Metadata metadata;
    private final ClusterBlocks blocks;
    private final ImmutableOpenMap<String, Custom> customs;
    private final ClusterName clusterName;
    private final boolean wasReadFromDiff;
    private final int minimumMasterNodesOnPublishingMaster;
    private volatile RoutingNodes routingNodes;

    public ClusterState(long version, String stateUUID, ClusterState state) {
        this(state.clusterName, version, stateUUID, state.metadata(), state.routingTable(), state.nodes(), state.blocks(), state.customs(), -1, false, state.routingNodes);
    }

    public ClusterState(ClusterName clusterName, long version, String stateUUID, Metadata metadata, RoutingTable routingTable, DiscoveryNodes nodes, ClusterBlocks blocks, ImmutableOpenMap<String, Custom> customs, int minimumMasterNodesOnPublishingMaster, boolean wasReadFromDiff, @Nullable RoutingNodes routingNodes) {
        this.version = version;
        this.stateUUID = stateUUID;
        this.clusterName = clusterName;
        this.metadata = metadata;
        this.routingTable = routingTable;
        this.nodes = nodes;
        this.blocks = blocks;
        this.customs = customs;
        this.minimumMasterNodesOnPublishingMaster = minimumMasterNodesOnPublishingMaster;
        this.wasReadFromDiff = wasReadFromDiff;
        this.routingNodes = routingNodes;
        assert (routingNodes == null || routingNodes.equals(new RoutingNodes(this))) : "RoutingNodes [" + routingNodes + "] are not consistent with this cluster state [" + new RoutingNodes(this) + "]";
    }

    public long term() {
        return this.coordinationMetadata().term();
    }

    public long version() {
        return this.version;
    }

    public long getVersion() {
        return this.version();
    }

    public long getVersionOrMetadataVersion() {
        return this.term() == 0L ? this.metadata().version() : this.version();
    }

    public String stateUUID() {
        return this.stateUUID;
    }

    public DiscoveryNodes nodes() {
        return this.nodes;
    }

    public DiscoveryNodes getNodes() {
        return this.nodes();
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public Metadata getMetadata() {
        return this.metadata();
    }

    public CoordinationMetadata coordinationMetadata() {
        return this.metadata.coordinationMetadata();
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable();
    }

    public ClusterBlocks blocks() {
        return this.blocks;
    }

    public ClusterBlocks getBlocks() {
        return this.blocks;
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public <T extends Custom> T custom(String type, T defaultValue) {
        return (T)this.customs.getOrDefault(type, defaultValue);
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public CoordinationMetadata.VotingConfiguration getLastAcceptedConfiguration() {
        return this.coordinationMetadata().getLastAcceptedConfiguration();
    }

    public CoordinationMetadata.VotingConfiguration getLastCommittedConfiguration() {
        return this.coordinationMetadata().getLastCommittedConfiguration();
    }

    public Set<CoordinationMetadata.VotingConfigExclusion> getVotingConfigExclusions() {
        return this.coordinationMetadata().getVotingConfigExclusions();
    }

    public int getMinimumMasterNodesOnPublishingMaster() {
        return this.minimumMasterNodesOnPublishingMaster;
    }

    public boolean wasReadFromDiff() {
        return this.wasReadFromDiff;
    }

    public RoutingNodes getRoutingNodes() {
        if (this.routingNodes != null) {
            return this.routingNodes;
        }
        this.routingNodes = new RoutingNodes(this);
        return this.routingNodes;
    }

    public String toString() {
        ToXContentFragment custom;
        StringBuilder sb = new StringBuilder();
        String TAB = "   ";
        sb.append("cluster uuid: ").append(this.metadata.clusterUUID()).append(" [committed: ").append(this.metadata.clusterUUIDCommitted()).append("]").append("\n");
        sb.append("version: ").append(this.version).append("\n");
        sb.append("state uuid: ").append(this.stateUUID).append("\n");
        sb.append("from_diff: ").append(this.wasReadFromDiff).append("\n");
        sb.append("meta data version: ").append(this.metadata.version()).append("\n");
        sb.append("   ").append("coordination_metadata:\n");
        sb.append("   ").append("   ").append("term: ").append(this.coordinationMetadata().term()).append("\n");
        sb.append("   ").append("   ").append("last_committed_config: ").append(this.coordinationMetadata().getLastCommittedConfiguration()).append("\n");
        sb.append("   ").append("   ").append("last_accepted_config: ").append(this.coordinationMetadata().getLastAcceptedConfiguration()).append("\n");
        sb.append("   ").append("   ").append("voting tombstones: ").append(this.coordinationMetadata().getVotingConfigExclusions()).append("\n");
        for (IndexMetadata indexMetadata : this.metadata) {
            sb.append("   ").append(indexMetadata.getIndex());
            sb.append(": v[").append(indexMetadata.getVersion()).append("], mv[").append(indexMetadata.getMappingVersion()).append("], sv[").append(indexMetadata.getSettingsVersion()).append("], av[").append(indexMetadata.getAliasesVersion()).append("]\n");
            for (int shard = 0; shard < indexMetadata.getNumberOfShards(); ++shard) {
                sb.append("   ").append("   ").append(shard).append(": ");
                sb.append("p_term [").append(indexMetadata.primaryTerm(shard)).append("], ");
                sb.append("isa_ids ").append(indexMetadata.inSyncAllocationIds(shard)).append("\n");
            }
        }
        if (!this.metadata.customs().isEmpty()) {
            sb.append("metadata customs:\n");
            for (ObjectObjectCursor objectObjectCursor : this.metadata.customs()) {
                String type = (String)objectObjectCursor.key;
                custom = (Metadata.Custom)objectObjectCursor.value;
                sb.append("   ").append(type).append(": ").append(custom);
            }
            sb.append("\n");
        }
        sb.append(this.blocks());
        sb.append(this.nodes());
        sb.append(this.routingTable());
        sb.append(this.getRoutingNodes());
        if (!this.customs.isEmpty()) {
            sb.append("customs:\n");
            for (ObjectObjectCursor objectObjectCursor : this.customs) {
                String type = (String)objectObjectCursor.key;
                custom = (Custom)objectObjectCursor.value;
                sb.append("   ").append(type).append(": ").append(custom);
            }
        }
        return sb.toString();
    }

    public boolean supersedes(ClusterState other) {
        return this.nodes().getMasterNodeId() != null && this.nodes().getMasterNodeId().equals(other.nodes().getMasterNodeId()) && this.version() > other.version();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        EnumSet<Metric> metrics = Metric.parseString(params.param("metric", "_all"), true);
        builder.field("cluster_uuid", this.metadata().clusterUUID());
        if (metrics.contains((Object)Metric.VERSION)) {
            builder.field("version", this.version);
            builder.field("state_uuid", this.stateUUID);
        }
        if (metrics.contains((Object)Metric.MASTER_NODE)) {
            builder.field("master_node", this.nodes().getMasterNodeId());
        }
        if (metrics.contains((Object)Metric.BLOCKS)) {
            builder.startObject("blocks");
            if (!this.blocks().global().isEmpty()) {
                builder.startObject("global");
                for (ClusterBlock clusterBlock : this.blocks().global()) {
                    clusterBlock.toXContent(builder, params);
                }
                builder.endObject();
            }
            if (!this.blocks().indices().isEmpty()) {
                builder.startObject("indices");
                for (ObjectObjectCursor objectObjectCursor : this.blocks().indices()) {
                    builder.startObject((String)objectObjectCursor.key);
                    for (ClusterBlock block : (Set)objectObjectCursor.value) {
                        block.toXContent(builder, params);
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.NODES)) {
            builder.startObject("nodes");
            for (DiscoveryNode discoveryNode : this.nodes) {
                discoveryNode.toXContent(builder, params);
            }
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.METADATA)) {
            this.metadata.toXContent(builder, params);
        }
        if (metrics.contains((Object)Metric.ROUTING_TABLE)) {
            builder.startObject("routing_table");
            builder.startObject("indices");
            for (IndexRoutingTable indexRoutingTable : this.routingTable()) {
                builder.startObject(indexRoutingTable.getIndex().getName());
                builder.startObject("shards");
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    builder.startArray(Integer.toString(indexShardRoutingTable.shardId().id()));
                    for (ShardRouting shardRouting : indexShardRoutingTable) {
                        shardRouting.toXContent(builder, params);
                    }
                    builder.endArray();
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.ROUTING_NODES)) {
            builder.startObject("routing_nodes");
            builder.startArray("unassigned");
            for (ShardRouting shardRouting : this.getRoutingNodes().unassigned()) {
                shardRouting.toXContent(builder, params);
            }
            builder.endArray();
            builder.startObject("nodes");
            for (RoutingNode routingNode : this.getRoutingNodes()) {
                builder.startArray(routingNode.nodeId() == null ? "null" : routingNode.nodeId());
                for (ShardRouting shardRouting : routingNode) {
                    shardRouting.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }
        if (metrics.contains((Object)Metric.CUSTOMS)) {
            for (ObjectObjectCursor objectObjectCursor : this.customs) {
                builder.startObject((String)objectObjectCursor.key);
                ((Custom)objectObjectCursor.value).toXContent(builder, params);
                builder.endObject();
            }
        }
        return builder;
    }

    public static Builder builder(ClusterName clusterName) {
        return new Builder(clusterName);
    }

    public static Builder builder(ClusterState state) {
        return new Builder(state);
    }

    @Override
    public Diff<ClusterState> diff(ClusterState previousState) {
        return new ClusterStateDiff(previousState, this);
    }

    public static Diff<ClusterState> readDiffFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        return new ClusterStateDiff(in, localNode);
    }

    public static ClusterState readFrom(StreamInput in, DiscoveryNode localNode) throws IOException {
        ClusterName clusterName = new ClusterName(in);
        Builder builder = new Builder(clusterName);
        builder.version = in.readLong();
        builder.uuid = in.readString();
        builder.metadata = Metadata.readFrom(in);
        builder.routingTable = RoutingTable.readFrom(in);
        builder.nodes = DiscoveryNodes.readFrom(in, localNode);
        builder.blocks = ClusterBlocks.readFrom(in);
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            Custom customIndexMetadata = in.readNamedWriteable(Custom.class);
            builder.putCustom(customIndexMetadata.getWriteableName(), customIndexMetadata);
        }
        builder.minimumMasterNodesOnPublishingMaster = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readVInt() : -1;
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.clusterName.writeTo(out);
        out.writeLong(this.version);
        out.writeString(this.stateUUID);
        this.metadata.writeTo(out);
        this.routingTable.writeTo(out);
        this.nodes.writeTo(out);
        this.blocks.writeTo(out);
        int numberOfCustoms = 0;
        for (Custom custom : this.customs.values()) {
            if (!FeatureAware.shouldSerialize(out, custom)) continue;
            ++numberOfCustoms;
        }
        out.writeVInt(numberOfCustoms);
        for (Custom custom : this.customs.values()) {
            if (!FeatureAware.shouldSerialize(out, custom)) continue;
            out.writeNamedWriteable(custom);
        }
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeVInt(this.minimumMasterNodesOnPublishingMaster);
        }
    }

    public static interface Custom
    extends NamedDiffable<Custom>,
    ToXContentFragment,
    FeatureAware {
        default public boolean isPrivate() {
            return false;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;
    }

    public static enum Metric {
        VERSION("version"),
        MASTER_NODE("master_node"),
        BLOCKS("blocks"),
        NODES("nodes"),
        METADATA("metadata"),
        ROUTING_TABLE("routing_table"),
        ROUTING_NODES("routing_nodes"),
        CUSTOMS("customs");

        private static Map<String, Metric> valueToEnum;
        private final String value;

        private Metric(String value) {
            this.value = value;
        }

        public static EnumSet<Metric> parseString(String param, boolean ignoreUnknown) {
            String[] metrics = Strings.splitStringByCommaToArray(param);
            EnumSet<Metric> result = EnumSet.noneOf(Metric.class);
            for (String metric : metrics) {
                if ("_all".equals(metric)) {
                    result = EnumSet.allOf(Metric.class);
                    break;
                }
                Metric m = valueToEnum.get(metric);
                if (m == null) {
                    if (ignoreUnknown) continue;
                    throw new IllegalArgumentException("Unknown metric [" + metric + "]");
                }
                result.add(m);
            }
            return result;
        }

        public String toString() {
            return this.value;
        }

        static {
            valueToEnum = new HashMap<String, Metric>();
            for (Metric metric : Metric.values()) {
                valueToEnum.put(metric.value, metric);
            }
        }
    }

    public static class Builder {
        private ClusterState previous;
        private final ClusterName clusterName;
        private long version = 0L;
        private String uuid = "_na_";
        private Metadata metadata = Metadata.EMPTY_METADATA;
        private RoutingTable routingTable = RoutingTable.EMPTY_ROUTING_TABLE;
        private DiscoveryNodes nodes = DiscoveryNodes.EMPTY_NODES;
        private ClusterBlocks blocks = ClusterBlocks.EMPTY_CLUSTER_BLOCK;
        private final ImmutableOpenMap.Builder<String, Custom> customs;
        private boolean fromDiff;
        private int minimumMasterNodesOnPublishingMaster = -1;

        public Builder(ClusterState state) {
            this.previous = state;
            this.clusterName = state.clusterName;
            this.version = state.version();
            this.uuid = state.stateUUID();
            this.nodes = state.nodes();
            this.routingTable = state.routingTable();
            this.metadata = state.metadata();
            this.blocks = state.blocks();
            this.customs = ImmutableOpenMap.builder(state.customs());
            this.minimumMasterNodesOnPublishingMaster = state.minimumMasterNodesOnPublishingMaster;
            this.fromDiff = false;
        }

        public Builder(ClusterName clusterName) {
            this.customs = ImmutableOpenMap.builder();
            this.clusterName = clusterName;
        }

        public Builder nodes(DiscoveryNodes.Builder nodesBuilder) {
            return this.nodes(nodesBuilder.build());
        }

        public Builder nodes(DiscoveryNodes nodes) {
            this.nodes = nodes;
            return this;
        }

        public DiscoveryNodes nodes() {
            return this.nodes;
        }

        public Builder routingTable(RoutingTable routingTable) {
            this.routingTable = routingTable;
            return this;
        }

        public Builder metadata(Metadata.Builder metadataBuilder) {
            return this.metadata(metadataBuilder.build());
        }

        public Builder metadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder blocks(ClusterBlocks.Builder blocksBuilder) {
            return this.blocks(blocksBuilder.build());
        }

        public Builder blocks(ClusterBlocks blocks) {
            this.blocks = blocks;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder incrementVersion() {
            ++this.version;
            this.uuid = ClusterState.UNKNOWN_UUID;
            return this;
        }

        public Builder stateUUID(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder minimumMasterNodesOnPublishingMaster(int minimumMasterNodesOnPublishingMaster) {
            this.minimumMasterNodesOnPublishingMaster = minimumMasterNodesOnPublishingMaster;
            return this;
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, Objects.requireNonNull(custom, type));
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder customs(ImmutableOpenMap<String, Custom> customs) {
            customs.stream().forEach(entry -> Objects.requireNonNull((Custom)entry.getValue(), (String)entry.getKey()));
            this.customs.putAll(customs);
            return this;
        }

        public Builder fromDiff(boolean fromDiff) {
            this.fromDiff = fromDiff;
            return this;
        }

        public ClusterState build() {
            if (ClusterState.UNKNOWN_UUID.equals(this.uuid)) {
                this.uuid = UUIDs.randomBase64UUID();
            }
            RoutingNodes routingNodes = this.previous != null && this.routingTable.indicesRouting() == this.previous.routingTable.indicesRouting() && this.nodes == this.previous.nodes ? this.previous.routingNodes : null;
            return new ClusterState(this.clusterName, this.version, this.uuid, this.metadata, this.routingTable, this.nodes, this.blocks, this.customs.build(), this.minimumMasterNodesOnPublishingMaster, this.fromDiff, routingNodes);
        }

        public static byte[] toBytes(ClusterState state) throws IOException {
            BytesStreamOutput os = new BytesStreamOutput();
            state.writeTo(os);
            return BytesReference.toBytes(os.bytes());
        }

        public static ClusterState fromBytes(byte[] data, DiscoveryNode localNode, NamedWriteableRegistry registry) throws IOException {
            NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(StreamInput.wrap(data), registry);
            return ClusterState.readFrom(in, localNode);
        }
    }

    private static class ClusterStateDiff
    implements Diff<ClusterState> {
        private final long toVersion;
        private final String fromUuid;
        private final String toUuid;
        private final ClusterName clusterName;
        private final Diff<RoutingTable> routingTable;
        private final Diff<DiscoveryNodes> nodes;
        private final Diff<Metadata> metadata;
        private final Diff<ClusterBlocks> blocks;
        private final Diff<ImmutableOpenMap<String, Custom>> customs;
        private final int minimumMasterNodesOnPublishingMaster;

        ClusterStateDiff(ClusterState before, ClusterState after) {
            this.fromUuid = before.stateUUID;
            this.toUuid = after.stateUUID;
            this.toVersion = after.version;
            this.clusterName = after.clusterName;
            this.routingTable = after.routingTable.diff(before.routingTable);
            this.nodes = after.nodes.diff(before.nodes);
            this.metadata = after.metadata.diff(before.metadata);
            this.blocks = after.blocks.diff(before.blocks);
            this.customs = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
            this.minimumMasterNodesOnPublishingMaster = after.minimumMasterNodesOnPublishingMaster;
        }

        ClusterStateDiff(StreamInput in, DiscoveryNode localNode) throws IOException {
            this.clusterName = new ClusterName(in);
            this.fromUuid = in.readString();
            this.toUuid = in.readString();
            this.toVersion = in.readLong();
            this.routingTable = RoutingTable.readDiffFrom(in);
            this.nodes = DiscoveryNodes.readDiffFrom(in, localNode);
            this.metadata = Metadata.readDiffFrom(in);
            this.blocks = ClusterBlocks.readDiffFrom(in);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
            this.minimumMasterNodesOnPublishingMaster = in.getVersion().onOrAfter(Version.V_6_7_0) ? in.readVInt() : -1;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.clusterName.writeTo(out);
            out.writeString(this.fromUuid);
            out.writeString(this.toUuid);
            out.writeLong(this.toVersion);
            this.routingTable.writeTo(out);
            this.nodes.writeTo(out);
            this.metadata.writeTo(out);
            this.blocks.writeTo(out);
            this.customs.writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                out.writeVInt(this.minimumMasterNodesOnPublishingMaster);
            }
        }

        @Override
        public ClusterState apply(ClusterState state) {
            Builder builder = new Builder(this.clusterName);
            if (this.toUuid.equals(state.stateUUID)) {
                return state;
            }
            if (!this.fromUuid.equals(state.stateUUID)) {
                throw new IncompatibleClusterStateVersionException(state.version, state.stateUUID, this.toVersion, this.fromUuid);
            }
            builder.stateUUID(this.toUuid);
            builder.version(this.toVersion);
            builder.routingTable(this.routingTable.apply(state.routingTable));
            builder.nodes(this.nodes.apply(state.nodes));
            builder.metadata(this.metadata.apply(state.metadata));
            builder.blocks(this.blocks.apply(state.blocks));
            builder.customs(this.customs.apply(state.customs));
            builder.minimumMasterNodesOnPublishingMaster(this.minimumMasterNodesOnPublishingMaster);
            builder.fromDiff(true);
            return builder.build();
        }
    }

    public static interface FeatureAware {
        default public Optional<String> getRequiredFeature() {
            return Optional.empty();
        }

        public static <T extends VersionedNamedWriteable & FeatureAware> boolean shouldSerialize(StreamOutput out, T custom) {
            if (out.getVersion().before(custom.getMinimalSupportedVersion())) {
                return false;
            }
            if (((FeatureAware)custom).getRequiredFeature().isPresent()) {
                String requiredFeature = ((FeatureAware)custom).getRequiredFeature().get();
                return out.hasFeature(requiredFeature) || !out.hasFeature("transport_client");
            }
            return true;
        }
    }
}

