/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.Map;
import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.snapshots.SnapshotId;

public final class SnapshotShardContext
extends ActionListener.Delegating<ShardSnapshotResult, ShardSnapshotResult> {
    private final Store store;
    private final MapperService mapperService;
    private final SnapshotId snapshotId;
    private final IndexId indexId;
    private final Engine.IndexCommitRef commitRef;
    @Nullable
    private final String shardStateIdentifier;
    private final IndexShardSnapshotStatus snapshotStatus;
    private final Version repositoryMetaVersion;
    private final Map<String, Object> userMetadata;

    public SnapshotShardContext(Store store, MapperService mapperService, SnapshotId snapshotId, IndexId indexId, Engine.IndexCommitRef commitRef, @Nullable String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, Version repositoryMetaVersion, Map<String, Object> userMetadata, ActionListener<ShardSnapshotResult> listener) {
        super(ActionListener.runBefore(listener, commitRef::close));
        this.store = store;
        this.mapperService = mapperService;
        this.snapshotId = snapshotId;
        this.indexId = indexId;
        this.commitRef = commitRef;
        this.shardStateIdentifier = shardStateIdentifier;
        this.snapshotStatus = snapshotStatus;
        this.repositoryMetaVersion = repositoryMetaVersion;
        this.userMetadata = userMetadata;
    }

    public Store store() {
        return this.store;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public SnapshotId snapshotId() {
        return this.snapshotId;
    }

    public IndexId indexId() {
        return this.indexId;
    }

    public IndexCommit indexCommit() {
        return this.commitRef.getIndexCommit();
    }

    @Nullable
    public String stateIdentifier() {
        return this.shardStateIdentifier;
    }

    public IndexShardSnapshotStatus status() {
        return this.snapshotStatus;
    }

    public Version getRepositoryMetaVersion() {
        return this.repositoryMetaVersion;
    }

    public Map<String, Object> userMetadata() {
        return this.userMetadata;
    }

    @Override
    public void onResponse(ShardSnapshotResult result) {
        this.delegate.onResponse(result);
    }
}

