/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.DispatchingRestToXContentListener;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestGetMappingAction
extends BaseRestHandler {
    private static final Logger logger = LogManager.getLogger(RestGetMappingAction.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(logger.getName());
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using include_type_name in get mapping requests is deprecated. The parameter will be removed in the next major version.";
    private final ThreadPool threadPool;

    public RestGetMappingAction(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_mapping"), new RestHandler.Route(RestRequest.Method.GET, "/_mappings"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/_mapping"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mapping"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mappings"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mappings/{type}"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mapping/{type}"), new RestHandler.Route(RestRequest.Method.HEAD, "/{index}/_mapping/{type}"), new RestHandler.Route(RestRequest.Method.GET, "/_mapping/{type}")));
    }

    @Override
    public String getName() {
        return "get_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        boolean includeTypeName = request.paramAsBoolean("include_type_name", false);
        if (request.method().equals((Object)RestRequest.Method.HEAD)) {
            deprecationLogger.critical(DeprecationCategory.TYPES, "get_mapping_types_removal", "Type exists requests are deprecated, as types have been deprecated.", new Object[0]);
        } else if (!includeTypeName && types.length > 0) {
            throw new IllegalArgumentException("Types cannot be provided in get mapping requests, unless include_type_name is set to true.");
        }
        if (request.hasParam("include_type_name")) {
            deprecationLogger.critical(DeprecationCategory.TYPES, "get_mapping_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        ((GetMappingsRequest)getMappingsRequest.indices(indices)).types(types);
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        TimeValue timeout = request.paramAsTime("master_timeout", getMappingsRequest.masterNodeTimeout());
        getMappingsRequest.masterNodeTimeout(timeout);
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        HttpChannel httpChannel = request.getHttpChannel();
        return channel -> new RestCancellableNodeClient(client, httpChannel).admin().indices().getMappings(getMappingsRequest, new DispatchingRestToXContentListener<StatusToXContentObject>(this.threadPool.executor("management"), (RestChannel)channel, request).map(getMappingsResponse -> new RestGetMappingsResponse(types, (GetMappingsResponse)getMappingsResponse, this.threadPool::relativeTimeInMillis, timeout)));
    }

    private static final class RestGetMappingsResponse
    implements StatusToXContentObject {
        private final String[] types;
        private final GetMappingsResponse response;
        private final LongSupplier relativeTimeSupplierMillis;
        private final TimeValue timeout;
        private final long startTimeMs;
        private final SortedSet<String> missingTypes;

        RestGetMappingsResponse(String[] types, GetMappingsResponse response, LongSupplier relativeTimeSupplierMillis, TimeValue timeout) {
            this.types = types;
            this.response = response;
            this.relativeTimeSupplierMillis = relativeTimeSupplierMillis;
            this.timeout = timeout;
            this.startTimeMs = relativeTimeSupplierMillis.getAsLong();
            this.missingTypes = Collections.unmodifiableSortedSet(RestGetMappingsResponse.getMissingTypes(types, response.getMappings()));
        }

        @Override
        public RestStatus status() {
            return this.missingTypes.isEmpty() ? RestStatus.OK : RestStatus.NOT_FOUND;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.relativeTimeSupplierMillis.getAsLong() - this.startTimeMs > this.timeout.millis()) {
                throw new ElasticsearchTimeoutException("Timed out getting mappings", new Object[0]);
            }
            ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> mappingsByIndex = this.response.getMappings();
            if (mappingsByIndex.isEmpty() && this.types.length != 0) {
                builder.close();
                throw new TypeMissingException("_all", String.join((CharSequence)",", this.types));
            }
            builder.startObject();
            if (!this.missingTypes.isEmpty()) {
                String message = String.format(Locale.ROOT, "type" + (this.missingTypes.size() == 1 ? "" : "s") + " [%s] missing", Strings.collectionToCommaDelimitedString(this.missingTypes));
                builder.field("error", message);
                builder.field("status", this.status().getStatus());
            }
            this.response.toXContent(builder, params);
            builder.endObject();
            return builder;
        }

        private static SortedSet<String> getMissingTypes(String[] types, ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> mappingsByIndex) {
            if (mappingsByIndex.isEmpty() && types.length != 0) {
                return Collections.emptySortedSet();
            }
            HashSet<String> typeNames = new HashSet<String>();
            for (ImmutableOpenMap<String, MappingMetadata> value : mappingsByIndex.values()) {
                for (ObjectCursor inner : value.keys()) {
                    typeNames.add((String)inner.value);
                }
            }
            SortedSet<String> difference = Sets.sortedDifference(Arrays.stream(types).collect(Collectors.toSet()), typeNames);
            ArrayList<String> matches = new ArrayList<String>();
            block2: for (String pattern : difference) {
                if (!pattern.contains("*")) continue;
                for (String typeName : typeNames) {
                    if (!Regex.simpleMatch(pattern, typeName)) continue;
                    matches.add(pattern);
                    continue block2;
                }
            }
            difference.removeAll(matches);
            return difference;
        }
    }
}

