/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.script.GeoPointFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractGeoPointScriptFieldQuery;

public class GeoPointScriptFieldGeoShapeQuery
extends AbstractGeoPointScriptFieldQuery {
    private final SpatialPredicate predicate;
    private final LatLonGeometry[] geometries;
    private final ShapeRelation relation;

    public GeoPointScriptFieldGeoShapeQuery(Script script, GeoPointFieldScript.LeafFactory leafFactory, String fieldName, ShapeRelation relation, LatLonGeometry ... geometries) {
        super(script, leafFactory, fieldName);
        this.geometries = geometries;
        this.relation = relation;
        this.predicate = GeoPointScriptFieldGeoShapeQuery.getPredicate(relation, geometries);
    }

    @Override
    protected boolean matches(long[] values, int count) {
        return this.predicate.matches(values, count);
    }

    @Override
    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return this.getClass().getSimpleName();
        }
        return this.fieldName() + ":" + this.getClass().getSimpleName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointScriptFieldGeoShapeQuery that = (GeoPointScriptFieldGeoShapeQuery)o;
        return this.relation == that.relation && Arrays.equals(this.geometries, that.geometries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relation, Arrays.hashCode(this.geometries));
    }

    private static SpatialPredicate getPredicate(ShapeRelation relation, LatLonGeometry ... geometries) {
        switch (relation) {
            case INTERSECTS: {
                GeoEncodingUtils.Component2DPredicate predicate = GeoEncodingUtils.createComponentPredicate(LatLonGeometry.create(geometries));
                return (values, count) -> {
                    for (int i = 0; i < count; ++i) {
                        long value = values[i];
                        int lat = (int)(value >>> 32);
                        int lon = (int)(value & 0xFFFFFFFFFFFFFFFFL);
                        if (!predicate.test(lat, lon)) continue;
                        return true;
                    }
                    return false;
                };
            }
            case DISJOINT: {
                GeoEncodingUtils.Component2DPredicate predicate = GeoEncodingUtils.createComponentPredicate(LatLonGeometry.create(geometries));
                return (values, count) -> {
                    for (int i = 0; i < count; ++i) {
                        long value = values[i];
                        int lat = (int)(value >>> 32);
                        int lon = (int)(value & 0xFFFFFFFFFFFFFFFFL);
                        if (!predicate.test(lat, lon)) continue;
                        return false;
                    }
                    return count > 0;
                };
            }
            case WITHIN: {
                GeoEncodingUtils.Component2DPredicate predicate = GeoEncodingUtils.createComponentPredicate(LatLonGeometry.create(geometries));
                return (values, count) -> {
                    for (int i = 0; i < count; ++i) {
                        long value = values[i];
                        int lat = (int)(value >>> 32);
                        int lon = (int)(value & 0xFFFFFFFFFFFFFFFFL);
                        if (predicate.test(lat, lon)) continue;
                        return false;
                    }
                    return count > 0;
                };
            }
            case CONTAINS: {
                Component2D[] component2DS = new Component2D[geometries.length];
                for (int i = 0; i < geometries.length; ++i) {
                    component2DS[i] = LatLonGeometry.create(geometries[i]);
                }
                return (values, count) -> {
                    Component2D.WithinRelation answer = Component2D.WithinRelation.DISJOINT;
                    for (int i = 0; i < count; ++i) {
                        long value = values[i];
                        double lat = GeoEncodingUtils.decodeLatitude((int)(value >>> 32));
                        double lon = GeoEncodingUtils.decodeLongitude((int)(value & 0xFFFFFFFFFFFFFFFFL));
                        for (Component2D component2D : component2DS) {
                            Component2D.WithinRelation withinRelation = component2D.withinPoint(lon, lat);
                            if (withinRelation == Component2D.WithinRelation.NOTWITHIN) {
                                return false;
                            }
                            if (withinRelation == Component2D.WithinRelation.DISJOINT) continue;
                            answer = withinRelation;
                        }
                    }
                    return answer == Component2D.WithinRelation.CANDIDATE;
                };
            }
        }
        throw new IllegalArgumentException("Unknown spatial relationship [" + relation.getRelationName() + "]");
    }

    @FunctionalInterface
    private static interface SpatialPredicate {
        public boolean matches(long[] var1, int var2);
    }
}

