/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.util.Arrays;
import org.elasticsearch.common.Strings;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.NamedClusterPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public class ManageOwnApiKeyClusterPrivilege
implements NamedClusterPrivilege {
    public static final ManageOwnApiKeyClusterPrivilege INSTANCE = new ManageOwnApiKeyClusterPrivilege();
    private static final String PRIVILEGE_NAME = "manage_own_api_key";
    public static final String API_KEY_ID_KEY = "_security_api_key_id";
    private final ClusterPermission permission = this.buildPermission(ClusterPermission.builder()).build();

    private ManageOwnApiKeyClusterPrivilege() {
    }

    @Override
    public String name() {
        return PRIVILEGE_NAME;
    }

    @Override
    public ClusterPermission.Builder buildPermission(ClusterPermission.Builder builder) {
        return builder.add(this, ManageOwnClusterPermissionCheck.INSTANCE);
    }

    @Override
    public ClusterPermission permission() {
        return this.permission;
    }

    private static final class ManageOwnClusterPermissionCheck
    extends ClusterPermission.ActionBasedPermissionCheck {
        public static final ManageOwnClusterPermissionCheck INSTANCE = new ManageOwnClusterPermissionCheck();

        private ManageOwnClusterPermissionCheck() {
            super(Automatons.patterns("cluster:admin/xpack/security/api_key/*"));
        }

        @Override
        protected boolean extendedCheck(String action, TransportRequest request, Authentication authentication) {
            if (request instanceof CreateApiKeyRequest) {
                return true;
            }
            if (request instanceof GetApiKeyRequest) {
                GetApiKeyRequest getApiKeyRequest = (GetApiKeyRequest)request;
                return this.checkIfUserIsOwnerOfApiKeys(authentication, getApiKeyRequest.getApiKeyId(), getApiKeyRequest.getUserName(), getApiKeyRequest.getRealmName(), getApiKeyRequest.ownedByAuthenticatedUser());
            }
            if (request instanceof InvalidateApiKeyRequest) {
                InvalidateApiKeyRequest invalidateApiKeyRequest = (InvalidateApiKeyRequest)request;
                String[] apiKeyIds = invalidateApiKeyRequest.getIds();
                if (apiKeyIds == null) {
                    return this.checkIfUserIsOwnerOfApiKeys(authentication, null, invalidateApiKeyRequest.getUserName(), invalidateApiKeyRequest.getRealmName(), invalidateApiKeyRequest.ownedByAuthenticatedUser());
                }
                return Arrays.stream(apiKeyIds).allMatch(id -> this.checkIfUserIsOwnerOfApiKeys(authentication, (String)id, invalidateApiKeyRequest.getUserName(), invalidateApiKeyRequest.getRealmName(), invalidateApiKeyRequest.ownedByAuthenticatedUser()));
            }
            if (request instanceof QueryApiKeyRequest) {
                QueryApiKeyRequest queryApiKeyRequest = (QueryApiKeyRequest)request;
                return queryApiKeyRequest.isFilterForCurrentUser();
            }
            throw new IllegalArgumentException("manage own api key privilege only supports API key requests (not " + request.getClass().getName() + ")");
        }

        @Override
        protected boolean doImplies(ClusterPermission.ActionBasedPermissionCheck permissionCheck) {
            return permissionCheck instanceof ManageOwnClusterPermissionCheck;
        }

        private boolean checkIfUserIsOwnerOfApiKeys(Authentication authentication, String apiKeyId, String username, String realmName, boolean ownedByAuthenticatedUser) {
            if (this.isCurrentAuthenticationUsingSameApiKeyIdFromRequest(authentication, apiKeyId)) {
                return true;
            }
            if (Authentication.AuthenticationType.API_KEY == authentication.getAuthenticationType()) {
                return false;
            }
            if (ownedByAuthenticatedUser) {
                return true;
            }
            if (Strings.hasText(username) && Strings.hasText(realmName)) {
                String sourceUserPrincipal = authentication.getUser().principal();
                String sourceRealmName = authentication.getSourceRealm().getName();
                return username.equals(sourceUserPrincipal) && realmName.equals(sourceRealmName);
            }
            return false;
        }

        private boolean isCurrentAuthenticationUsingSameApiKeyIdFromRequest(Authentication authentication, String apiKeyId) {
            if (Authentication.AuthenticationType.API_KEY == authentication.getAuthenticationType()) {
                String authenticatedApiKeyId = (String)authentication.getMetadata().get(ManageOwnApiKeyClusterPrivilege.API_KEY_ID_KEY);
                if (Strings.hasText(apiKeyId)) {
                    return apiKeyId.equals(authenticatedApiKeyId);
                }
            }
            return false;
        }
    }
}

