/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public abstract class UnaryExpression
extends Expression {
    private final Expression child;

    protected UnaryExpression(Source source, Expression child) {
        super(source, Collections.singletonList(child));
        this.child = child;
    }

    @Override
    public final UnaryExpression replaceChildren(List<Expression> newChildren) {
        return this.replaceChild(newChildren.get(0));
    }

    protected abstract UnaryExpression replaceChild(Expression var1);

    public Expression child() {
        return this.child;
    }

    @Override
    public boolean foldable() {
        return this.child.foldable();
    }

    @Override
    public Nullability nullable() {
        return this.child.nullable();
    }

    @Override
    public boolean resolved() {
        return this.child.resolved();
    }

    @Override
    public DataType dataType() {
        return this.child.dataType();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.child);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryExpression other = (UnaryExpression)obj;
        return Objects.equals(this.child, other.child);
    }
}

