/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.jcajce.provider.ECUtil;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvECPublicKey
implements ECPublicKey,
ProvKey<AsymmetricECPublicKey> {
    private static final long serialVersionUID = -569596969144472700L;
    private transient AsymmetricECPublicKey baseKey;

    ProvECPublicKey(Algorithm algorithm, ECPublicKey eCPublicKey) {
        ECDomainParameters eCDomainParameters = ECUtil.convertFromSpec(eCPublicKey.getParams());
        this.baseKey = new AsymmetricECPublicKey(algorithm, eCDomainParameters, ECUtil.convertPoint(eCDomainParameters.getCurve(), eCPublicKey.getW()));
    }

    ProvECPublicKey(Algorithm algorithm, ECPublicKeySpec eCPublicKeySpec) {
        ECDomainParameters eCDomainParameters = ECUtil.convertFromSpec(eCPublicKeySpec.getParams());
        this.baseKey = new AsymmetricECPublicKey(algorithm, eCDomainParameters, ECUtil.convertPoint(eCDomainParameters.getCurve(), eCPublicKeySpec.getW()));
    }

    ProvECPublicKey(AsymmetricECPublicKey asymmetricECPublicKey) {
        this.baseKey = asymmetricECPublicKey;
    }

    @Override
    public AsymmetricECPublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public ECParameterSpec getParams() {
        return ECUtil.convertToSpec(this.baseKey.getDomainParameters());
    }

    @Override
    public ECPoint getW() {
        return new ECPoint(this.baseKey.getW().getAffineXCoord().toBigInteger(), this.baseKey.getW().getAffineYCoord().toBigInteger());
    }

    public String toString() {
        return KeyUtil.publicKeyToString("EC", this.baseKey.getW(), this.baseKey.getDomainParameters());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPublicKey)) {
            return false;
        }
        if (object instanceof ProvECPublicKey) {
            ProvECPublicKey provECPublicKey = (ProvECPublicKey)object;
            return this.baseKey.equals(provECPublicKey.baseKey);
        }
        ECPublicKey eCPublicKey = (ECPublicKey)object;
        return Arrays.areEqual(this.getEncoded(), eCPublicKey.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Algorithm algorithm = (Algorithm)objectInputStream.readObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.baseKey = new AsymmetricECPublicKey(algorithm, byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.baseKey.getAlgorithm());
        objectOutputStream.writeObject(this.getEncoded());
    }
}

