/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.fleet.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.IntConsumer;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.xcontent.XContentParser;

public class RestFleetSearchAction
extends BaseRestHandler {
    public String getName() {
        return "fleet_search_action";
    }

    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_fleet/_fleet_search"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_fleet/_fleet_search"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchRequest searchRequest = request.hasParam("min_compatible_shard_node") ? new SearchRequest(Version.fromString((String)request.param("min_compatible_shard_node"))) : new SearchRequest();
        Object[] indices = searchRequest.indices();
        if (indices.length > 1) {
            throw new IllegalArgumentException("Fleet search API only supports searching a single index. Found: [" + Arrays.toString(indices) + "].");
        }
        IntConsumer setSize = size -> searchRequest.source().size(size);
        request.withContentOrSourceParamParserOrNull(parser -> RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)request, (XContentParser)parser, (NamedWriteableRegistry)client.getNamedWriteableRegistry(), (IntConsumer)setSize, (restRequest, sr) -> {
            String[] stringWaitForCheckpoints = request.paramAsStringArray("wait_for_checkpoints", Strings.EMPTY_ARRAY);
            long[] waitForCheckpoints = new long[stringWaitForCheckpoints.length];
            for (int i = 0; i < stringWaitForCheckpoints.length; ++i) {
                waitForCheckpoints[i] = Long.parseLong(stringWaitForCheckpoints[i]);
            }
            Object[] indices1 = Strings.splitStringByCommaToArray((String)request.param("index"));
            if (indices1.length > 1) {
                throw new IllegalArgumentException("Fleet search API only supports searching a single index. Found: [" + Arrays.toString(indices1) + "].");
            }
            if (waitForCheckpoints.length != 0) {
                sr.setWaitForCheckpoints(Collections.singletonMap(indices1[0], waitForCheckpoints));
            }
            TimeValue waitForCheckpointsTimeout = request.paramAsTime("wait_for_checkpoints_timeout", TimeValue.timeValueSeconds((long)30L));
            sr.setWaitForCheckpointsTimeout(waitForCheckpointsTimeout);
        }));
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.execute((ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)new RestStatusToXContentListener(channel));
        };
    }

    protected Set<String> responseParams() {
        return RestSearchAction.RESPONSE_PARAMS;
    }
}

