/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.xpack.spatial.index.fielddata.Component2DVisitor;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.GeometryDocValueReader;

class LatLonShapeDocValuesQuery
extends Query {
    private final String field;
    private final LatLonGeometry[] geometries;
    private final ShapeField.QueryRelation relation;

    LatLonShapeDocValuesQuery(String field, ShapeField.QueryRelation relation, LatLonGeometry ... geometries) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field;
        this.geometries = geometries;
        this.relation = relation;
    }

    public String toString(String otherField) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(otherField)) {
            sb.append(this.field);
            sb.append(':');
            sb.append(this.relation);
            sb.append(':');
        }
        sb.append(Arrays.toString(this.geometries));
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        LatLonShapeDocValuesQuery other = (LatLonShapeDocValuesQuery)((Object)obj);
        return this.field.equals(other.field) && this.relation == other.relation && Arrays.equals(this.geometries, other.geometries);
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + this.relation.hashCode();
        h = 31 * h + Arrays.hashCode(this.geometries);
        return h;
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) {
        if (this.relation == ShapeField.QueryRelation.CONTAINS) {
            return this.getContainsWeight(scoreMode, boost);
        }
        return this.getStandardWeight(scoreMode, boost);
    }

    private ConstantScoreWeight getStandardWeight(final ScoreMode scoreMode, final float boost) {
        return new ConstantScoreWeight(this, boost){
            final Component2D component2D;
            {
                super(arg0, arg1);
                this.component2D = LatLonGeometry.create((LatLonGeometry[])LatLonShapeDocValuesQuery.this.geometries);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final BinaryDocValues values = context.reader().getBinaryDocValues(LatLonShapeDocValuesQuery.this.field);
                if (values == null) {
                    return null;
                }
                final GeometryDocValueReader reader = new GeometryDocValueReader();
                final Component2DVisitor visitor = Component2DVisitor.getVisitor(this.component2D, LatLonShapeDocValuesQuery.this.relation, CoordinateEncoder.GEO);
                TwoPhaseIterator iterator = new TwoPhaseIterator((DocIdSetIterator)values){

                    public boolean matches() throws IOException {
                        reader.reset(values.binaryValue());
                        visitor.reset();
                        reader.visit(visitor);
                        return visitor.matches();
                    }

                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, boost, scoreMode, iterator);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{LatLonShapeDocValuesQuery.this.field});
            }
        };
    }

    private ConstantScoreWeight getContainsWeight(final ScoreMode scoreMode, final float boost) {
        final ArrayList<Component2D> components2D = new ArrayList<Component2D>(this.geometries.length);
        for (int i = 0; i < this.geometries.length; ++i) {
            LatLonGeometry geometry = this.geometries[i];
            if (geometry instanceof Rectangle) {
                Rectangle r = (Rectangle)geometry;
                if (r.minLon > r.maxLon) {
                    components2D.add(LatLonGeometry.create((LatLonGeometry[])new LatLonGeometry[]{new Rectangle(r.minLat, r.maxLat, r.minLon, 180.0)}));
                    components2D.add(LatLonGeometry.create((LatLonGeometry[])new LatLonGeometry[]{new Rectangle(r.minLat, r.maxLat, -180.0, r.maxLon)}));
                    continue;
                }
            }
            components2D.add(LatLonGeometry.create((LatLonGeometry[])new LatLonGeometry[]{geometry}));
        }
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                final BinaryDocValues values = context.reader().getBinaryDocValues(LatLonShapeDocValuesQuery.this.field);
                if (values == null) {
                    return null;
                }
                final GeometryDocValueReader reader = new GeometryDocValueReader();
                final Component2DVisitor[] visitors = new Component2DVisitor[components2D.size()];
                for (int i = 0; i < components2D.size(); ++i) {
                    visitors[i] = Component2DVisitor.getVisitor((Component2D)components2D.get(i), LatLonShapeDocValuesQuery.this.relation, CoordinateEncoder.GEO);
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator((DocIdSetIterator)values){

                    public boolean matches() throws IOException {
                        reader.reset(values.binaryValue());
                        for (Component2DVisitor visitor : visitors) {
                            visitor.reset();
                            reader.visit(visitor);
                            if (visitor.matches()) continue;
                            return false;
                        }
                        return true;
                    }

                    public float matchCost() {
                        return 1000.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, boost, scoreMode, iterator);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{LatLonShapeDocValuesQuery.this.field});
            }
        };
    }
}

