/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.eql.EqlFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.eql.plugin.EqlStatsAction;
import org.elasticsearch.xpack.eql.plugin.EqlStatsRequest;
import org.elasticsearch.xpack.eql.plugin.EqlStatsResponse;

public class EqlFeatureSet
implements XPackFeatureSet {
    private final Client client;

    @Inject
    public EqlFeatureSet(Client client) {
        this.client = client;
    }

    public String name() {
        return "eql";
    }

    public boolean available() {
        return true;
    }

    public boolean enabled() {
        return true;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        EqlStatsRequest request = new EqlStatsRequest();
        request.includeStats(true);
        this.client.execute((ActionType)EqlStatsAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> {
            List countersPerNode = r.getNodes().stream().map(EqlStatsResponse.NodeStatsResponse::getStats).filter(Objects::nonNull).collect(Collectors.toList());
            Counters mergedCounters = Counters.merge(countersPerNode);
            listener.onResponse((Object)new EqlFeatureSetUsage(mergedCounters.toNestedMap()));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

