/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.parser;

import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.elasticsearch.xpack.eql.parser.EqlBaseBaseVisitor;
import org.elasticsearch.xpack.eql.parser.ParsingException;
import org.elasticsearch.xpack.ql.parser.ParserUtils;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.tree.Source;

abstract class AbstractBuilder
extends EqlBaseBaseVisitor<Object> {
    AbstractBuilder() {
    }

    public Object visit(ParseTree tree) {
        return ParserUtils.visit(x$0 -> super.visit(x$0), (ParseTree)tree);
    }

    protected LogicalPlan plan(ParseTree ctx) {
        return (LogicalPlan)ParserUtils.typedParsing((ParseTreeVisitor)this, (ParseTree)ctx, LogicalPlan.class);
    }

    protected List<LogicalPlan> plans(List<? extends ParserRuleContext> ctxs) {
        return ParserUtils.visitList((ParseTreeVisitor)this, ctxs, LogicalPlan.class);
    }

    public static String unquoteString(Source source) {
        String text = source.text();
        if (text == null) {
            return null;
        }
        if (text.startsWith("?")) {
            throw new ParsingException(source, "Use triple double quotes [\"\"\"] to define unescaped string literals, not [?{}]", Character.valueOf(text.charAt(1)));
        }
        if (text.startsWith("\"\"\"")) {
            return text.substring(3, text.length() - 3);
        }
        AbstractBuilder.checkForSingleQuotedString(source, text, 0);
        text = text.substring(1, text.length() - 1);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\\') {
                switch (text.charAt(++i)) {
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case 'u': {
                        ++i;
                        i = AbstractBuilder.handleUnicodePoints(source, sb, text, i);
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    default: {
                        sb.append('\\').append(text.charAt(i));
                    }
                }
                ++i;
                continue;
            }
            sb.append(text.charAt(i++));
        }
        return sb.toString();
    }

    private static int handleUnicodePoints(Source source, StringBuilder sb, String text, int i) {
        int startIdx = i + 1;
        int endIdx = text.indexOf(125, startIdx);
        String unicodeSequence = text.substring(startIdx, endIdx);
        int length = unicodeSequence.length();
        if (length < 2 || length > 8) {
            throw new ParsingException(source, "Unicode sequence should use [2-8] hex digits, [{}] has [{}]", text.substring(startIdx - 3, endIdx + 1), length);
        }
        sb.append(AbstractBuilder.hexToUnicode(source, unicodeSequence));
        return endIdx;
    }

    private static String hexToUnicode(Source source, String hex) {
        try {
            int code = Integer.parseInt(hex, 16);
            if (code >= 55296 && code <= 57343) {
                throw new ParsingException(source, "Invalid unicode character code, [{}] is a surrogate code", hex);
            }
            return String.valueOf(Character.toChars(code));
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(source, "Invalid unicode character code [{}]", hex);
        }
    }

    private static void checkForSingleQuotedString(Source source, String text, int i) {
        if (text.charAt(i) == '\'') {
            throw new ParsingException(source, "Use double quotes [\"] to define string literals, not single quotes [']", new Object[0]);
        }
    }
}

