/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class PostStartTrialResponse
extends ActionResponse {
    private Status status;
    private Map<String, String[]> acknowledgeMessages;
    private String acknowledgeMessage;

    PostStartTrialResponse(StreamInput in) throws IOException {
        super(in);
        this.status = (Status)in.readEnum(Status.class);
        if (in.getVersion().onOrAfter(Version.V_6_3_0)) {
            this.acknowledgeMessage = in.readOptionalString();
            int size = in.readVInt();
            HashMap<String, String[]> acknowledgeMessages = new HashMap<String, String[]>(size);
            for (int i = 0; i < size; ++i) {
                String feature = in.readString();
                int nMessages = in.readVInt();
                String[] messages = new String[nMessages];
                for (int j = 0; j < nMessages; ++j) {
                    messages[j] = in.readString();
                }
                acknowledgeMessages.put(feature, messages);
            }
            this.acknowledgeMessages = acknowledgeMessages;
        } else {
            this.acknowledgeMessages = Collections.emptyMap();
        }
    }

    PostStartTrialResponse(Status status) {
        this(status, Collections.emptyMap(), null);
    }

    PostStartTrialResponse(Status status, Map<String, String[]> acknowledgeMessages, String acknowledgeMessage) {
        this.status = status;
        this.acknowledgeMessages = acknowledgeMessages;
        this.acknowledgeMessage = acknowledgeMessage;
    }

    public Status getStatus() {
        return this.status;
    }

    public void writeTo(StreamOutput out) throws IOException {
        Version version = Version.V_6_3_0;
        if (out.getVersion().onOrAfter(version)) {
            out.writeEnum((Enum)this.status);
            out.writeOptionalString(this.acknowledgeMessage);
            out.writeVInt(this.acknowledgeMessages.size());
            for (Map.Entry<String, String[]> entry : this.acknowledgeMessages.entrySet()) {
                out.writeString(entry.getKey());
                out.writeVInt(entry.getValue().length);
                for (String message : entry.getValue()) {
                    out.writeString(message);
                }
            }
        } else if (this.status == Status.UPGRADED_TO_TRIAL) {
            out.writeEnum((Enum)Pre63Status.UPGRADED_TO_TRIAL);
        } else if (this.status == Status.TRIAL_ALREADY_ACTIVATED) {
            out.writeEnum((Enum)Pre63Status.TRIAL_ALREADY_ACTIVATED);
        } else {
            throw new IllegalArgumentException("Starting trial on node with version [" + Version.CURRENT + "] requires acknowledgement parameter.");
        }
    }

    Map<String, String[]> getAcknowledgementMessages() {
        return this.acknowledgeMessages;
    }

    String getAcknowledgementMessage() {
        return this.acknowledgeMessage;
    }

    public static enum Status {
        UPGRADED_TO_TRIAL(true, null, RestStatus.OK),
        TRIAL_ALREADY_ACTIVATED(false, "Operation failed: Trial was already activated.", RestStatus.FORBIDDEN),
        NEED_ACKNOWLEDGEMENT(false, "Operation failed: Needs acknowledgement.", RestStatus.OK);

        private final boolean isTrialStarted;
        private final String errorMessage;
        private final RestStatus restStatus;

        private Status(boolean isTrialStarted, String errorMessage, RestStatus restStatus) {
            this.isTrialStarted = isTrialStarted;
            this.errorMessage = errorMessage;
            this.restStatus = restStatus;
        }

        boolean isTrialStarted() {
            return this.isTrialStarted;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }

        RestStatus getRestStatus() {
            return this.restStatus;
        }
    }

    static enum Pre63Status {
        UPGRADED_TO_TRIAL,
        TRIAL_ALREADY_ACTIVATED;

    }
}

