/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rollup.RollupV2;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleType;
import org.elasticsearch.xpack.core.ilm.MigrateAction;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.SearchableSnapshotAction;
import org.elasticsearch.xpack.core.ilm.UnfollowAction;

public class TimeseriesLifecycleType
implements LifecycleType {
    public static final TimeseriesLifecycleType INSTANCE = new TimeseriesLifecycleType();
    private static final Logger logger = LogManager.getLogger(TimeseriesLifecycleType.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger((String)logger.getName());
    public static final String TYPE = "timeseries";
    static final String HOT_PHASE = "hot";
    static final String WARM_PHASE = "warm";
    static final String COLD_PHASE = "cold";
    static final String FROZEN_PHASE = "frozen";
    static final String DELETE_PHASE = "delete";
    static final List<String> ORDERED_VALID_PHASES = Arrays.asList("hot", "warm", "cold", "frozen", "delete");
    public static final String FREEZE_ACTION_DEPRECATION_WARNING = "the freeze action has been deprecated and will be removed in a future release";
    static final List<String> ORDERED_VALID_HOT_ACTIONS = Stream.of("set_priority", "unfollow", "rollover", "readonly", RollupV2.isEnabled() ? "rollup" : null, "shrink", "forcemerge", "searchable_snapshot").filter(Objects::nonNull).collect(Collectors.toList());
    static final List<String> ORDERED_VALID_WARM_ACTIONS = Arrays.asList("set_priority", "unfollow", "readonly", "allocate", "migrate", "shrink", "forcemerge");
    static final List<String> ORDERED_VALID_COLD_ACTIONS = Stream.of("set_priority", "unfollow", "readonly", "searchable_snapshot", "allocate", "migrate", "freeze", RollupV2.isEnabled() ? "rollup" : null).filter(Objects::nonNull).collect(Collectors.toList());
    static final List<String> ORDERED_VALID_FROZEN_ACTIONS = Arrays.asList("unfollow", "searchable_snapshot");
    static final List<String> ORDERED_VALID_DELETE_ACTIONS = Arrays.asList("wait_for_snapshot", "delete");
    static final Set<String> VALID_HOT_ACTIONS = Sets.newHashSet(ORDERED_VALID_HOT_ACTIONS);
    static final Set<String> VALID_WARM_ACTIONS = Sets.newHashSet(ORDERED_VALID_WARM_ACTIONS);
    static final Set<String> VALID_COLD_ACTIONS = Sets.newHashSet(ORDERED_VALID_COLD_ACTIONS);
    static final Set<String> VALID_FROZEN_ACTIONS = Sets.newHashSet(ORDERED_VALID_FROZEN_ACTIONS);
    static final Set<String> VALID_DELETE_ACTIONS = Sets.newHashSet(ORDERED_VALID_DELETE_ACTIONS);
    private static final Map<String, Set<String>> ALLOWED_ACTIONS = org.elasticsearch.core.Map.of((Object)"hot", VALID_HOT_ACTIONS, (Object)"warm", VALID_WARM_ACTIONS, (Object)"cold", VALID_COLD_ACTIONS, (Object)"delete", VALID_DELETE_ACTIONS, (Object)"frozen", VALID_FROZEN_ACTIONS);
    static final Set<String> HOT_ACTIONS_THAT_REQUIRE_ROLLOVER = Sets.newHashSet((Object[])new String[]{"readonly", "shrink", "forcemerge", "rollup", "searchable_snapshot"});
    static final Set<String> ACTIONS_CANNOT_FOLLOW_SEARCHABLE_SNAPSHOT = new LinkedHashSet<String>(Arrays.asList("forcemerge", "freeze", "shrink", "rollup"));

    private TimeseriesLifecycleType() {
    }

    public void writeTo(StreamOutput out) throws IOException {
    }

    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public List<Phase> getOrderedPhases(Map<String, Phase> phases) {
        ArrayList<Phase> orderedPhases = new ArrayList<Phase>(ORDERED_VALID_PHASES.size());
        for (String phaseName : ORDERED_VALID_PHASES) {
            HashMap<String, LifecycleAction> actionMap;
            Phase phase = phases.get(phaseName);
            if (phase == null) continue;
            Map<String, LifecycleAction> actions = phase.getActions();
            if (!actions.containsKey("unfollow") && (actions.containsKey("rollover") || actions.containsKey("shrink") || actions.containsKey("searchable_snapshot"))) {
                actionMap = new HashMap<String, LifecycleAction>(phase.getActions());
                actionMap.put("unfollow", new UnfollowAction());
                phase = new Phase(phase.getName(), phase.getMinimumAge(), actionMap);
            }
            if (TimeseriesLifecycleType.shouldInjectMigrateStepForPhase(phase)) {
                actionMap = new HashMap<String, LifecycleAction>(phase.getActions());
                actionMap.put("migrate", new MigrateAction(true));
                phase = new Phase(phase.getName(), phase.getMinimumAge(), actionMap);
            }
            orderedPhases.add(phase);
        }
        return orderedPhases;
    }

    public static boolean shouldInjectMigrateStepForPhase(Phase phase) {
        AllocateAction allocateAction = (AllocateAction)phase.getActions().get("allocate");
        if (allocateAction != null && TimeseriesLifecycleType.definesAllocationRules(allocateAction)) {
            return false;
        }
        if (phase.getActions().get("searchable_snapshot") != null) {
            return false;
        }
        MigrateAction migrateAction = (MigrateAction)phase.getActions().get("migrate");
        return migrateAction == null;
    }

    @Override
    public String getNextPhaseName(String currentPhaseName, Map<String, Phase> phases) {
        int index = ORDERED_VALID_PHASES.indexOf(currentPhaseName);
        if (index < 0 && !"new".equals(currentPhaseName)) {
            throw new IllegalArgumentException("[" + currentPhaseName + "] is not a valid phase for lifecycle type [" + TYPE + "]");
        }
        while (++index < ORDERED_VALID_PHASES.size()) {
            String phaseName = ORDERED_VALID_PHASES.get(index);
            if (!phases.containsKey(phaseName)) continue;
            return phaseName;
        }
        return null;
    }

    @Override
    public String getPreviousPhaseName(String currentPhaseName, Map<String, Phase> phases) {
        if ("new".equals(currentPhaseName)) {
            return null;
        }
        int index = ORDERED_VALID_PHASES.indexOf(currentPhaseName);
        if (index < 0) {
            throw new IllegalArgumentException("[" + currentPhaseName + "] is not a valid phase for lifecycle type [" + TYPE + "]");
        }
        while (--index >= 0) {
            String phaseName = ORDERED_VALID_PHASES.get(index);
            if (!phases.containsKey(phaseName)) continue;
            return phaseName;
        }
        return null;
    }

    @Override
    public List<LifecycleAction> getOrderedActions(Phase phase) {
        Map<String, LifecycleAction> actions = phase.getActions();
        switch (phase.getName()) {
            case "hot": {
                return ORDERED_VALID_HOT_ACTIONS.stream().map(actions::get).filter(Objects::nonNull).collect(Collectors.toList());
            }
            case "warm": {
                return ORDERED_VALID_WARM_ACTIONS.stream().map(actions::get).filter(Objects::nonNull).collect(Collectors.toList());
            }
            case "cold": {
                return ORDERED_VALID_COLD_ACTIONS.stream().map(actions::get).filter(Objects::nonNull).collect(Collectors.toList());
            }
            case "frozen": {
                return ORDERED_VALID_FROZEN_ACTIONS.stream().map(actions::get).filter(Objects::nonNull).collect(Collectors.toList());
            }
            case "delete": {
                return ORDERED_VALID_DELETE_ACTIONS.stream().map(actions::get).filter(Objects::nonNull).collect(Collectors.toList());
            }
        }
        throw new IllegalArgumentException("lifecycle type [timeseries] does not support phase [" + phase.getName() + "]");
    }

    @Override
    public String getNextActionName(String currentActionName, Phase phase) {
        List<String> orderedActionNames;
        switch (phase.getName()) {
            case "hot": {
                orderedActionNames = ORDERED_VALID_HOT_ACTIONS;
                break;
            }
            case "warm": {
                orderedActionNames = ORDERED_VALID_WARM_ACTIONS;
                break;
            }
            case "cold": {
                orderedActionNames = ORDERED_VALID_COLD_ACTIONS;
                break;
            }
            case "frozen": {
                orderedActionNames = ORDERED_VALID_FROZEN_ACTIONS;
                break;
            }
            case "delete": {
                orderedActionNames = ORDERED_VALID_DELETE_ACTIONS;
                break;
            }
            default: {
                throw new IllegalArgumentException("lifecycle type [timeseries] does not support phase [" + phase.getName() + "]");
            }
        }
        int index = orderedActionNames.indexOf(currentActionName);
        if (index < 0) {
            throw new IllegalArgumentException("[" + currentActionName + "] is not a valid action for phase [" + phase.getName() + "] in lifecycle type [" + TYPE + "]");
        }
        while (++index < orderedActionNames.size()) {
            String actionName = orderedActionNames.get(index);
            if (!phase.getActions().containsKey(actionName)) continue;
            return actionName;
        }
        return null;
    }

    @Override
    public void validate(Collection<Phase> phases) {
        phases.forEach(phase -> {
            if (!ALLOWED_ACTIONS.containsKey(phase.getName())) {
                throw new IllegalArgumentException("Timeseries lifecycle does not support phase [" + phase.getName() + "]");
            }
            phase.getActions().forEach((actionName, action) -> {
                if (!ALLOWED_ACTIONS.get(phase.getName()).contains(actionName)) {
                    throw new IllegalArgumentException("invalid action [" + actionName + "] defined in phase [" + phase.getName() + "]");
                }
            });
        });
        String invalidHotPhaseActions = phases.stream().filter(phase -> HOT_PHASE.equals(phase.getName())).filter(phase -> !phase.getActions().containsKey("rollover")).flatMap(phase -> Sets.intersection(phase.getActions().keySet(), HOT_ACTIONS_THAT_REQUIRE_ROLLOVER).stream()).collect(Collectors.joining(", "));
        if (Strings.hasText((String)invalidHotPhaseActions)) {
            throw new IllegalArgumentException("the [" + invalidHotPhaseActions + "] action(s) may not be used in the [" + HOT_PHASE + "] phase without an accompanying [" + "rollover" + "] action");
        }
        String phasesWithConflictingMigrationActions = phases.stream().filter(phase -> phase.getActions().containsKey("migrate") && ((MigrateAction)phase.getActions().get("migrate")).isEnabled() && phase.getActions().containsKey("allocate") && TimeseriesLifecycleType.definesAllocationRules((AllocateAction)phase.getActions().get("allocate"))).map(Phase::getName).collect(Collectors.joining(","));
        if (Strings.hasText((String)phasesWithConflictingMigrationActions)) {
            throw new IllegalArgumentException("phases [" + phasesWithConflictingMigrationActions + "] specify an enabled " + "migrate" + " action and an " + "allocate" + " action with allocation rules. specify only a single data migration in each phase");
        }
        TimeseriesLifecycleType.validateActionsFollowingSearchableSnapshot(phases);
        TimeseriesLifecycleType.validateAllSearchableSnapshotActionsUseSameRepository(phases);
        TimeseriesLifecycleType.validateFrozenPhaseHasSearchableSnapshotAction(phases);
        this.logDeprecationWarningForFreezeAction(phases);
    }

    private void logDeprecationWarningForFreezeAction(Collection<Phase> phases) {
        if (phases.stream().anyMatch(phase -> phase.getActions().containsKey("freeze"))) {
            deprecationLogger.critical(DeprecationCategory.OTHER, "ilm_freee_action", FREEZE_ACTION_DEPRECATION_WARNING, new Object[0]);
        }
    }

    static void validateActionsFollowingSearchableSnapshot(Collection<Phase> phases) {
        String phasesDefiningIllegalActions;
        Optional<Phase> hotPhaseWithSearchableSnapshot = phases.stream().filter(phase -> phase.getName().equals(HOT_PHASE)).filter(phase -> phase.getActions().containsKey("searchable_snapshot")).findAny();
        ArrayList<Phase> phasesFollowingSearchableSnapshot = new ArrayList<Phase>(phases.size());
        if (hotPhaseWithSearchableSnapshot.isPresent()) {
            for (Phase phase2 : phases) {
                if (phase2.getName().equals(HOT_PHASE)) continue;
                phasesFollowingSearchableSnapshot.add(phase2);
            }
        } else {
            Optional<Phase> coldPhaseWithSearchableSnapshot = phases.stream().filter(phase -> phase.getName().equals(COLD_PHASE)).filter(phase -> phase.getActions().containsKey("searchable_snapshot")).findAny();
            if (coldPhaseWithSearchableSnapshot.isPresent()) {
                for (Phase phase3 : phases) {
                    if (!phase3.getName().equals(FROZEN_PHASE)) continue;
                    phasesFollowingSearchableSnapshot.add(phase3);
                    break;
                }
            }
        }
        if (Strings.hasText((String)(phasesDefiningIllegalActions = phasesFollowingSearchableSnapshot.stream().filter(phase -> !Collections.disjoint(ACTIONS_CANNOT_FOLLOW_SEARCHABLE_SNAPSHOT, phase.getActions().keySet())).map(Phase::getName).collect(Collectors.joining(","))))) {
            throw new IllegalArgumentException("phases [" + phasesDefiningIllegalActions + "] define one or more of " + ACTIONS_CANNOT_FOLLOW_SEARCHABLE_SNAPSHOT + " actions which are not allowed after a managed index is mounted as a searchable snapshot");
        }
    }

    static void validateAllSearchableSnapshotActionsUseSameRepository(Collection<Phase> phases) {
        Set allRepos = phases.stream().flatMap(phase -> phase.getActions().entrySet().stream()).filter(e -> ((String)e.getKey()).equals("searchable_snapshot")).map(Map.Entry::getValue).map(action -> (SearchableSnapshotAction)action).map(SearchableSnapshotAction::getSnapshotRepository).collect(Collectors.toSet());
        if (allRepos.size() > 1) {
            throw new IllegalArgumentException("policy specifies [searchable_snapshot] action multiple times with differing repositories " + allRepos + ", the same repository must be used for all searchable snapshot actions");
        }
    }

    public static String validateMonotonicallyIncreasingPhaseTimings(Collection<Phase> phases) {
        ArrayList<String> errors = new ArrayList<String>();
        HashSet invalidPhases = new HashSet();
        for (int i = 0; i < ORDERED_VALID_PHASES.size(); ++i) {
            Phase phase;
            String phaseName = ORDERED_VALID_PHASES.get(i);
            Optional<Phase> maybePhase = phases.stream().filter(p -> phaseName.equals(p.getName())).filter(p -> p.getMinimumAge() != null && !p.getMinimumAge().equals((Object)TimeValue.ZERO)).findFirst();
            if (!maybePhase.isPresent() || invalidPhases.contains((phase = maybePhase.get()).getName())) continue;
            TimeValue phaseMinAge = phase.getMinimumAge();
            HashSet<String> followingPhases = new HashSet<String>(ORDERED_VALID_PHASES.subList(i + 1, ORDERED_VALID_PHASES.size()));
            Set<Phase> phasesWithBadAges = phases.stream().filter(p -> followingPhases.contains(p.getName())).filter(p -> p.getMinimumAge() != null && !p.getMinimumAge().equals((Object)TimeValue.ZERO)).filter(p -> p.getMinimumAge().compareTo(phaseMinAge) < 0).collect(Collectors.toSet());
            if (phasesWithBadAges.size() <= 0) continue;
            phasesWithBadAges.forEach(p -> invalidPhases.add(p.getName()));
            Iterator it = phasesWithBadAges.iterator();
            Phase badPhase = (Phase)it.next();
            String error = "Your policy is configured to run the " + badPhase.getName() + " phase (min_age: " + badPhase.getMinimumAge() + ")";
            if (phasesWithBadAges.size() > 1) {
                while (it.hasNext()) {
                    badPhase = (Phase)it.next();
                    error = error + ", the " + badPhase.getName() + " phase (min_age: " + badPhase.getMinimumAge() + ")";
                }
                StringBuilder builder = new StringBuilder();
                int last_comma_index = error.lastIndexOf(",");
                builder.append(error, 0, last_comma_index);
                builder.append(" and");
                builder.append(error.substring(last_comma_index + 1));
                error = builder.toString();
            }
            error = error + " before the " + phaseName + " phase (min_age: " + phase.getMinimumAge() + "). You should change the phase timing so that the phases will execute in the order of hot, warm, then cold.";
            errors.add(error);
        }
        return Strings.collectionToCommaDelimitedString(errors);
    }

    static void validateFrozenPhaseHasSearchableSnapshotAction(Collection<Phase> phases) {
        Optional<Phase> maybeFrozenPhase = phases.stream().filter(p -> FROZEN_PHASE.equals(p.getName())).findFirst();
        maybeFrozenPhase.ifPresent(p -> {
            if (!p.getActions().containsKey("searchable_snapshot")) {
                throw new IllegalArgumentException("policy specifies the [frozen] phase without a corresponding [searchable_snapshot] action, but a searchable snapshot action is required in the frozen phase");
            }
        });
    }

    private static boolean definesAllocationRules(AllocateAction action) {
        return !action.getRequire().isEmpty() || !action.getInclude().isEmpty() || !action.getExclude().isEmpty();
    }
}

